/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fastjrun.client.BaseApplicationClient;
import com.fastjrun.helper.StringHelper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.testng.Assert;
import org.testng.annotations.DataProvider;

public abstract class BaseApplicationClientTest<T extends BaseApplicationClient> {
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected Properties propParams = new Properties();
    protected T baseApplicationClient;

    public abstract void prepareApplicationClient(String var1);

    protected void init(String envName) {
        this.baseApplicationClient.initSDKConfig();
        try {
            InputStream inParam = this.getClass().getResourceAsStream("/testdata/" + envName + ".properties");
            this.propParams.load(inParam);
        }
        catch (IOException e) {
            this.log.error("load config for error:{}", (Throwable)e);
        }
    }

    @DataProvider(name="loadParam")
    public Object[][] loadParam(Method method) {
        Set<String> keys = this.propParams.stringPropertyNames();
        ArrayList<String[]> parameters = new ArrayList<String[]>();
        for (String key : keys) {
            if (!key.startsWith(this.getClass().getSimpleName() + "." + method.getName() + ".")) continue;
            String value = this.propParams.getProperty(key);
            parameters.add(new String[]{value});
        }
        Object[][] object = new Object[parameters.size()][];
        for (int i = 0; i < object.length; ++i) {
            String[] str = (String[])parameters.get(i);
            object[i] = new String[str.length];
            System.arraycopy(str, 0, object[i], 0, str.length);
        }
        return object;
    }

    protected <T> void processAssertion(JsonNode assertJson, Object responseBody, Class<T> classType) {
        if (assertJson != null && assertJson.isObject()) {
            Iterator it = assertJson.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String key = (String)entry.getKey();
                if (key.equals("code")) continue;
                String jsonNodeText = ((JsonNode)entry.getValue()).asText();
                this.processObject(key, responseBody, classType, jsonNodeText, "");
            }
        }
    }

    private <T> void processObject(String key, Object object, Class<T> classType, String expectedValue, String info) {
        String char2;
        String[] keyFields = key.split("\\.");
        int length = keyFields.length;
        String tterMethodName = keyFields[0].split("\\[")[0];
        info = info.equals("") ? tterMethodName : info + "." + tterMethodName;
        if (tterMethodName.length() > 1 && !(char2 = String.valueOf(tterMethodName.charAt(1))).equals(char2.toUpperCase())) {
            tterMethodName = StringHelper.toUpperCaseFirstOne((String)tterMethodName);
        }
        try {
            Method method = classType.getMethod("get" + tterMethodName, new Class[0]);
            Object returnValue = method.invoke(object, new Object[0]);
            Class returnClass = null;
            Class newClassType = null;
            if (keyFields[0].indexOf("[") > 0) {
                returnClass = method.getGenericReturnType();
                Type[] typeArguments = ((ParameterizedType)((Object)returnClass)).getActualTypeArguments();
                newClassType = (Class)typeArguments[0];
                int size = (Integer)List.class.getMethod("size", new Class[0]).invoke(returnValue, new Object[0]);
                String indexStr = keyFields[0].split("\\[")[1].split("]")[0];
                if (indexStr.length() > 0) {
                    info = info + "[" + indexStr + "]";
                    int index = Integer.parseInt(indexStr);
                    if (size > index) {
                        returnValue = List.class.getMethod("get", Integer.TYPE).invoke(returnValue, index);
                    } else {
                        Assert.fail((String)(info + " is null"));
                    }
                } else {
                    info = info + "[]";
                    boolean isEqual = false;
                    for (int i = 0; i < size; ++i) {
                        returnValue = List.class.getMethod("get", Integer.TYPE).invoke(returnValue, i);
                        if (!expectedValue.equals(returnValue.toString())) continue;
                        isEqual = true;
                        break;
                    }
                    if (!isEqual) {
                        Assert.fail((String)(info + " doesn't have" + " value:" + expectedValue));
                    }
                }
            } else {
                newClassType = returnClass = method.getReturnType();
            }
            if (length == 1) {
                Assert.assertEquals((Object)returnValue, (Object)expectedValue, (String)info);
            } else {
                this.processObject(key.substring(key.indexOf(".") + 1), returnValue, newClassType, expectedValue, info);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

