/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fastjrun.client.BaseApplicationClient;
import com.fastjrun.helper.StringHelper;
import com.fastjrun.test.AbstractAdVancedTestNGSpringContextTest;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.testng.Assert;

public abstract class BaseApplicationClientTest<T extends BaseApplicationClient>
extends AbstractAdVancedTestNGSpringContextTest {
    protected T baseApplicationClient;

    public abstract void prepareApplicationClient();

    protected <T> void processAssertion(JsonNode assertJson, Object responseBody, Class<T> classType) {
        if (assertJson != null && assertJson.isObject()) {
            Iterator it = assertJson.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String key = (String)entry.getKey();
                if (key.equals("code")) continue;
                String jsonNodeText = ((JsonNode)entry.getValue()).asText();
                this.processObject(key, responseBody, classType, jsonNodeText, "");
            }
        }
    }

    private <T> void processObject(String key, Object object, Class<T> classType, String expectedValue, String info) {
        String char2;
        String[] keyFields = key.split("\\.");
        int length = keyFields.length;
        String tterMethodName = keyFields[0].split("\\[")[0];
        info = info.equals("") ? tterMethodName : info + "." + tterMethodName;
        if (tterMethodName.length() > 1 && !(char2 = String.valueOf(tterMethodName.charAt(1))).equals(char2.toUpperCase())) {
            tterMethodName = StringHelper.toUpperCaseFirstOne((String)tterMethodName);
        }
        try {
            Method method = classType.getMethod("get" + tterMethodName, new Class[0]);
            Object returnValue = method.invoke(object, new Object[0]);
            Class returnClass = null;
            Class newClassType = null;
            if (keyFields[0].indexOf("[") > 0) {
                returnClass = method.getGenericReturnType();
                Type[] typeArguments = ((ParameterizedType)((Object)returnClass)).getActualTypeArguments();
                newClassType = (Class)typeArguments[0];
                int size = (Integer)List.class.getMethod("size", new Class[0]).invoke(returnValue, new Object[0]);
                String indexStr = keyFields[0].split("\\[")[1].split("]")[0];
                if (indexStr.length() > 0) {
                    info = info + "[" + indexStr + "]";
                    int index = Integer.parseInt(indexStr);
                    if (size > index) {
                        returnValue = List.class.getMethod("get", Integer.TYPE).invoke(returnValue, index);
                    } else {
                        Assert.fail((String)(info + " is null"));
                    }
                } else {
                    info = info + "[]";
                    boolean isEqual = false;
                    for (int i = 0; i < size; ++i) {
                        returnValue = List.class.getMethod("get", Integer.TYPE).invoke(returnValue, i);
                        if (!expectedValue.equals(returnValue.toString())) continue;
                        isEqual = true;
                        break;
                    }
                    if (!isEqual) {
                        Assert.fail((String)(info + " doesn't have value:" + expectedValue));
                    }
                }
            } else {
                newClassType = returnClass = method.getReturnType();
            }
            if (length == 1) {
                Assert.assertEquals((Object)returnValue, (Object)expectedValue, (String)info);
            } else {
                this.processObject(key.substring(key.indexOf(".") + 1), returnValue, newClassType, expectedValue, info);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

