/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.helper;

import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Map;

public class StringHelper {
    public static final String DEFAULT_ENCODING = "UTF-8";

    public static String escape(String src, Map<String, String> map) {
        if (src == null || src.trim().length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        StringCharacterIterator sci = new StringCharacterIterator(src);
        char c = sci.first();
        while (c != '\uffff') {
            String ch = String.valueOf(c);
            if (map.containsKey(ch)) {
                ch = map.get(ch);
            }
            sb.append(ch);
            c = sci.next();
        }
        return sb.toString();
    }

    public static String escapeSQL(String input) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("'", "''");
        return StringHelper.escape(input, hashMap);
    }

    public static String escapeXML(String input) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("<", "&lt;");
        hashMap.put(">", "&gt;");
        hashMap.put("'", "&apos;");
        hashMap.put("\"", "&quot;");
        hashMap.put("&", "&amp;");
        return StringHelper.escape(input, hashMap);
    }

    public static String removeComma(String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (',' == string.charAt(i)) continue;
            sb.append(string.charAt(i));
        }
        return sb.toString();
    }

    public static String toLetterOrDigit(String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i))) {
                sb.append(string.charAt(i));
                continue;
            }
            sb.append("X");
        }
        return sb.toString();
    }

    public static String toLetter(String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetter(string.charAt(i))) {
                sb.append(string.charAt(i));
                continue;
            }
            if (Character.isDigit(string.charAt(i))) {
                switch (string.charAt(i)) {
                    case '0': {
                        sb.append("A");
                        break;
                    }
                    case '1': {
                        sb.append("B");
                        break;
                    }
                    case '2': {
                        sb.append("C");
                        break;
                    }
                    case '3': {
                        sb.append("D");
                        break;
                    }
                    case '4': {
                        sb.append("E");
                        break;
                    }
                    case '5': {
                        sb.append("F");
                        break;
                    }
                    case '6': {
                        sb.append("G");
                        break;
                    }
                    case '7': {
                        sb.append("H");
                        break;
                    }
                    case '8': {
                        sb.append("I");
                        break;
                    }
                    case '9': {
                        sb.append("J");
                    }
                }
                continue;
            }
            sb.append("M");
        }
        return sb.toString();
    }

    public static String bytes2hex(byte[] bytes) {
        String result = "";
        String b = "";
        for (int i = 0; i < bytes.length; ++i) {
            b = Integer.toHexString(bytes[i] & 0xFF);
            if (b.length() == 1) {
                b = "0" + b;
            }
            result = result + b;
        }
        return result.toUpperCase();
    }

    public static byte[] hex2bytes(String hexString) {
        hexString = hexString.toUpperCase();
        char[] chars = hexString.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int index = 0;
        for (int i = 0; i < chars.length; i += 2) {
            byte newByte = 0;
            newByte = (byte)(newByte | StringHelper.char2byte(chars[i]));
            newByte = (byte)(newByte << 4);
            bytes[index] = newByte = (byte)(newByte | StringHelper.char2byte(chars[i + 1]));
            ++index;
        }
        return bytes;
    }

    public static byte char2byte(char ch) {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': {
                return 10;
            }
            case 'B': {
                return 11;
            }
            case 'C': {
                return 12;
            }
            case 'D': {
                return 13;
            }
            case 'E': {
                return 14;
            }
            case 'F': {
                return 15;
            }
        }
        return 0;
    }

    private static void byte2hex(byte b, StringBuilder sb) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        sb.append(hexChars[high]);
        sb.append(hexChars[low]);
    }

    public static String toHexString(byte[] bytes, char c) {
        StringBuilder sb = new StringBuilder();
        int len = bytes.length;
        for (int i = 0; i < len; ++i) {
            StringHelper.byte2hex(bytes[i], sb);
            if (i >= len - 1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int len = bytes.length;
        for (int i = 0; i < len; ++i) {
            StringHelper.byte2hex(bytes[i], sb);
        }
        return sb.toString();
    }

    public static boolean isEmpty(String str) {
        return null == str || "".equals(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return str != null && !"".equals(str.trim());
    }

    public static String replace(String string, String replacement) {
        if (string != null) {
            return string.replaceAll(replacement, "");
        }
        return null;
    }

    public static String trim(String string) {
        if (StringHelper.isEmpty(string)) {
            return "";
        }
        return string.trim();
    }

    public static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }
}

