/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.helper;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeHelper {
    public static final String DF14 = "DF14";
    public static final String DF17 = "DF17";
    private static final String FORMAT_DF14 = "yyyyMMddHHmmss";
    private static final String FORMAT_DF17 = "yyyyMMddHHmmssSSS";

    public static String getCurrentTime(String format) {
        Calendar calendar = Calendar.getInstance();
        return TimeHelper.getTimeInFormat(calendar, format);
    }

    public static String getFormatDate(Date date, String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return TimeHelper.getTimeInFormat(calendar, format);
    }

    private static String getTimeInFormat(Calendar calendar, String format) {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_DF14);
        if (format.equals(DF14)) {
            df = new SimpleDateFormat(FORMAT_DF14);
        } else if (format.equals(DF17)) {
            df = new SimpleDateFormat(FORMAT_DF17);
        }
        return df.format(calendar.getTime());
    }

    public static Date getDateInFormat(String time, String format) {
        Calendar calendar = Calendar.getInstance();
        if (format.equals(DF14)) {
            calendar.set(Integer.parseInt(time.substring(0, 4)), Integer.parseInt(time.substring(4, 6)), Integer.parseInt(time.substring(6, 8)), Integer.parseInt(time.substring(8, 10)), Integer.parseInt(time.substring(10, 12)), Integer.parseInt(time.substring(12)));
        } else if (format.equals(DF17)) {
            calendar.set(Integer.parseInt(time.substring(0, 4)), Integer.parseInt(time.substring(4, 6)), Integer.parseInt(time.substring(6, 8)), Integer.parseInt(time.substring(8, 10)), Integer.parseInt(time.substring(10, 12)), Integer.parseInt(time.substring(12, 14)));
            calendar.set(14, Integer.parseInt(time.substring(14)));
        }
        return calendar.getTime();
    }

    public static Date getOffsetDate(Date date, int timeMeasurement, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int measurement = 0;
        if (timeMeasurement == 13) {
            measurement = 13;
        } else if (timeMeasurement == 12) {
            measurement = 12;
        } else if (timeMeasurement == 10) {
            measurement = 10;
        } else if (timeMeasurement == 5) {
            measurement = 5;
        } else if (timeMeasurement == 2) {
            measurement = 2;
        } else if (timeMeasurement == 1) {
            measurement = 1;
        }
        calendar.add(measurement, amount);
        return calendar.getTime();
    }
}

