/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.helper;

import com.fastjrun.helper.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class EncryptHelper {
    private static final String UTF8 = "utf-8";

    public static String md5Digest(String src) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] b = md.digest(src.getBytes(UTF8));
        return EncryptHelper.byte2HexStr(b);
    }

    public static String base64Encoder(String src) throws Exception {
        return Base64.encode(src.getBytes(UTF8));
    }

    public static String base64Decoder(String dest) throws Exception {
        return new String(Base64.decode(dest), UTF8);
    }

    private static String byte2HexStr(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            String s = Integer.toHexString(b[i] & 0xFF);
            if (s.length() == 1) {
                sb.append("0");
            }
            sb.append(s.toUpperCase());
        }
        return sb.toString();
    }

    public static void encrypt(String key, InputStream is, OutputStream os) throws Exception {
        EncryptHelper.encryptOrDecrypt(key, 1, is, os);
    }

    public static void decrypt(String key, InputStream is, OutputStream os) throws Exception {
        EncryptHelper.encryptOrDecrypt(key, 2, is, os);
    }

    private static void encryptOrDecrypt(String key, int mode, InputStream is, OutputStream os) throws Exception {
        DESKeySpec dks = new DESKeySpec(key.getBytes());
        SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
        SecretKey desKey = skf.generateSecret(dks);
        Cipher cipher = Cipher.getInstance("DES");
        if (mode == 1) {
            cipher.init(1, desKey);
            CipherInputStream cis = new CipherInputStream(is, cipher);
            EncryptHelper.doCopy(cis, os);
        } else if (mode == 2) {
            cipher.init(2, desKey);
            CipherOutputStream cos = new CipherOutputStream(os, cipher);
            EncryptHelper.doCopy(is, cos);
        }
    }

    public static void doCopy(InputStream is, OutputStream os) throws IOException {
        int numBytes;
        byte[] bytes = new byte[64];
        while ((numBytes = is.read(bytes)) != -1) {
            os.write(bytes, 0, numBytes);
        }
        os.flush();
        os.close();
        is.close();
    }
}

