/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fastjrun.common.util.FastJsonObjectMapper;
import java.util.ArrayList;
import java.util.List;

public class JacksonUtils {
    public static ObjectMapper objectMapper = new FastJsonObjectMapper();

    public static <T> T readValue(String jsonStr, Class<T> valueType) {
        try {
            return (T)objectMapper.readValue(jsonStr, valueType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> readList(JsonNode jsonNode, Class<T> valueType) {
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{valueType});
        ArrayList<T> list = new ArrayList<T>();
        while (jsonNode.elements().hasNext()) {
            JsonNode element = (JsonNode)jsonNode.elements().next();
            T t = JacksonUtils.readValue(element.toString(), valueType);
            list.add(t);
        }
        return list;
    }

    public static String toJSon(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JsonNode toJsonNode(String data) {
        try {
            return objectMapper.readTree(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObjectNode createObjectNode() {
        try {
            return objectMapper.createObjectNode();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayNode createArrayNode() {
        try {
            return objectMapper.createArrayNode();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String invokeMethodName(String jTypeName) {
        String jsonInvokeMethodName = "asText";
        switch (jTypeName) {
            case "Boolean": {
                jsonInvokeMethodName = "asBoolean";
                break;
            }
            case "Integer": {
                jsonInvokeMethodName = "asInt";
                break;
            }
            case "Long": {
                jsonInvokeMethodName = "asLong";
                break;
            }
            case "Double": {
                jsonInvokeMethodName = "asDouble";
                break;
            }
        }
        return jsonInvokeMethodName;
    }
}

