/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.codeg.generator;

import com.fastjrun.codeg.common.CodeGConstants;
import com.fastjrun.codeg.common.CodeGException;
import com.fastjrun.codeg.generator.common.BaseControllerGenerator;
import com.fastjrun.helper.StringHelper;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.EClassType;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JFieldVar;
import java.util.Properties;

public abstract class BaseRPCGenerator
extends BaseControllerGenerator {
    static String rpcApi = "api.";
    static String rpcBiz = "biz.";
    protected AbstractJClass apiClass;
    protected JDefinedClass apiManagerClass;

    public AbstractJClass getApiClass() {
        return this.apiClass;
    }

    public void setApiClass(AbstractJClass apiClass) {
        this.apiClass = apiClass;
    }

    public JDefinedClass getApiManagerClass() {
        return this.apiManagerClass;
    }

    public void setApiManagerClass(JDefinedClass apiManagerClass) {
        this.apiManagerClass = apiManagerClass;
    }

    protected void processAPI() {
        CodeGConstants.ControllerType controllerType = this.commonController.getControllerType();
        if (!this.commonController.is_new()) {
            this.apiClass = this.cm.ref(this.commonController.getName());
        } else {
            JDefinedClass apiClassTemp;
            try {
                apiClassTemp = this.cm._class(this.packageNamePrefix + rpcApi + this.commonController.getClientName(), EClassType.INTERFACE);
                if (controllerType.apiParentName != null && !controllerType.apiParentName.equals("")) {
                    apiClassTemp._implements(this.cm.ref(controllerType.apiParentName));
                }
            }
            catch (JClassAlreadyExistsException e) {
                String msg = this.commonController.getClientName() + " is already exists.";
                this.log.error(msg, (Throwable)e);
                throw new CodeGException("CG504", msg, (Exception)((Object)e));
            }
            this.addClassDeclaration(apiClassTemp);
            this.apiClass = apiClassTemp;
        }
    }

    protected void processAPIManager() {
        CodeGConstants.ControllerType controllerType = this.commonController.getControllerType();
        try {
            this.apiManagerClass = this.cm._class(this.packageNamePrefix + rpcBiz + this.commonController.getName());
            if (controllerType.providerParentName != null && !controllerType.providerParentName.equals("")) {
                this.apiManagerClass._extends(this.cm.ref(controllerType.providerParentName));
            }
        }
        catch (JClassAlreadyExistsException e) {
            String msg = this.commonController.getName() + " is already exists.";
            this.log.error(msg, (Throwable)e);
            throw new CodeGException("CG504", msg, (Exception)((Object)e));
        }
        this.apiManagerClass._implements(this.apiClass);
        this.apiManagerClass.annotate(this.cm.ref("org.springframework.stereotype.Service")).param("value", StringHelper.toLowerCaseFirstOne((String)this.commonController.getClientName()));
        this.addClassDeclaration(this.apiManagerClass);
        String serviceName = this.commonController.getServiceName();
        JFieldVar fieldVar = this.apiManagerClass.field(4, (AbstractJType)this.serviceGenerator.getServiceClass(), serviceName);
        fieldVar.annotate(this.cm.ref("org.springframework.beans.factory.annotation.Autowired"));
        fieldVar.annotate(this.cm.ref("org.springframework.beans.factory.annotation.Qualifier")).param("value", this.commonController.getServiceRef());
    }

    @Override
    public void generate() {
        this.processAPI();
        if (!this.isApi()) {
            if (this.isClient()) {
                this.processClient();
                this.processClientTest();
                this.clientTestParam = new Properties();
            } else {
                this.processAPIManager();
                if (this.getMockModel() != CodeGConstants.MockModel.MockModel_Common) {
                    this.genreateControllerPath();
                    this.processController();
                }
            }
        }
        this.generatorControllerMethod();
    }
}

