/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.codeg.generator;

import com.fastjrun.codeg.common.CodeGException;
import com.fastjrun.codeg.common.FJColumn;
import com.fastjrun.codeg.common.FJTable;
import com.fastjrun.codeg.generator.MybatisDaoTestMethodGenerator;
import com.fastjrun.codeg.generator.common.BaseCMGenerator;
import com.fastjrun.codeg.generator.common.MybatisAFDaoConstants;
import com.fastjrun.codeg.generator.common.MybatisAFServiceConstants;
import com.fastjrun.codeg.helper.MysqlSqlHelper;
import com.fastjrun.codeg.helper.SQLHelperFactory;
import com.fastjrun.codeg.helper.SqlHelper;
import com.fastjrun.helper.StringHelper;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.EClassType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JConditional;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JDocComment;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JForLoop;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class MybatisAFGenerator
extends BaseCMGenerator
implements MybatisAFDaoConstants,
MybatisAFServiceConstants {
    static String PACKAGE_ENTITY_NAME = "entity.";
    static String PACKAGE_DAO_WITH_BASE = "dao.Base";
    static String PACKAGE_SERVICE_WITH_BASE = "service.Base";
    static String PACKAGE_SERVICE_IMPL_WITH_BASE = "service.base.impl.Base";
    static String PACKAGE_CONTROLLER_WITH_BASE = "web.base.controller.Base";
    static String ENTITY_PARENT_CLASS_NAME = "com.fastjrun.entity.BaseEntity";
    protected FJTable fjTable;
    protected JDefinedClass entityClass;
    protected JDefinedClass daoClass;
    protected JDefinedClass sqlBuilderClass;
    protected JDefinedClass serviceClass;
    protected JDefinedClass serviceImplClass;
    protected JDefinedClass controllerClass;
    protected boolean supportController;
    protected boolean supportTest;
    protected String mybatisVersion;
    protected Properties daoTestParam;

    public Properties getDaoTestParam() {
        return this.daoTestParam;
    }

    public void setDaoTestParam(Properties daoTestParam) {
        this.daoTestParam = daoTestParam;
    }

    public boolean isSupportController() {
        return this.supportController;
    }

    public void setSupportController(boolean supportController) {
        this.supportController = supportController;
    }

    public String getMybatisVersion() {
        return this.mybatisVersion;
    }

    public void setMybatisVersion(String mybatisVersion) {
        this.mybatisVersion = mybatisVersion;
    }

    public boolean isSupportTest() {
        return this.supportTest;
    }

    public void setSupportTest(boolean supportTest) {
        this.supportTest = supportTest;
    }

    public void setFjTable(FJTable fjTable) {
        this.fjTable = fjTable;
    }

    protected void processEntity() {
        String className = this.packageNamePrefix + PACKAGE_ENTITY_NAME + this.fjTable.getClassName();
        try {
            this.entityClass = this.cm._class(className);
        }
        catch (JClassAlreadyExistsException e) {
            String msg = "fjTable class\uff1a" + this.fjTable.getName() + " is already exists.";
            this.log.error(msg, (Throwable)e);
            throw new CodeGException("CG504", msg, (Exception)((Object)e));
        }
        this.entityClass._extends(this.cm.ref(ENTITY_PARENT_CLASS_NAME));
        this.entityClass._implements(this.cm.ref("java.io.Serializable"));
        long hashCode = 0L;
        hashCode += (long)this.entityClass.getClass().getName().hashCode();
        this.addClassDeclaration(this.entityClass);
        Map<String, FJColumn> columns = this.fjTable.getColumns();
        JMethod toStringMethod = this.entityClass.method(1, (AbstractJType)this.cm.ref("String"), "toString");
        toStringMethod.annotate(this.cm.ref("Override"));
        JBlock toStringMethodBlk = toStringMethod.body();
        JVar toStringSBVar = toStringMethodBlk.decl((AbstractJType)this.cm.ref("StringBuilder"), "sb", (IJExpression)JExpr._new((AbstractJType)this.cm.ref("StringBuilder")));
        int index = 0;
        toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg(JExpr.lit((String)this.fjTable.getClassName()).plus((IJExpression)JExpr.lit((String)" ["))));
        for (FJColumn FJColumn2 : columns.values()) {
            String char2;
            String name = FJColumn2.getFieldName();
            hashCode += (long)name.hashCode();
            String dataType = FJColumn2.getDatatype();
            AbstractJClass jType = this.cm.ref(dataType);
            JFieldVar fieldVar = this.entityClass.field(4, (AbstractJType)jType, name);
            JDocComment jdoc = fieldVar.javadoc();
            jdoc.add((Object)FJColumn2.getName());
            if (FJColumn2.getComment() != null && FJColumn2.getComment().length() > 0) {
                jdoc.add((Object)"<br/>\n");
                jdoc.add((Object)FJColumn2.getComment());
            }
            JFieldRef nameRef = JExpr.refthis((String)name);
            if (index > 0) {
                toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)",")));
            }
            ++index;
            toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)name)));
            toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"=")));
            toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)nameRef));
            String tterMethodName = name;
            if (name.length() > 1 && !(char2 = String.valueOf(name.charAt(1))).equals(char2.toUpperCase())) {
                tterMethodName = StringHelper.toUpperCaseFirstOne((String)name);
            }
            JMethod getMethod = this.entityClass.method(1, (AbstractJType)jType, "get" + tterMethodName);
            hashCode += (long)getMethod.name().hashCode();
            JBlock getMethodBlk = getMethod.body();
            getMethodBlk._return((IJExpression)nameRef);
            JMethod setMethod = this.entityClass.method(1, (AbstractJType)this.cm.VOID, "set" + tterMethodName);
            JVar jvar = setMethod.param((AbstractJType)jType, name);
            hashCode += (long)setMethod.name().hashCode();
            JBlock setMethodBlk = setMethod.body();
            setMethodBlk.assign((IJAssignmentTarget)nameRef, (IJExpression)jvar);
        }
        toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"]")));
        toStringMethodBlk._return((IJExpression)toStringSBVar.invoke("toString"));
        this.entityClass.field(28, (AbstractJType)this.cm.LONG, "serialVersionUID", (IJExpression)JExpr.lit((long)hashCode));
    }

    protected void processDaoTest(MybatisDaoTestMethodGenerator mybatisDaoTestMethodGenerator) {
        JDefinedClass daoTestClass;
        try {
            daoTestClass = this.cmTest._class(this.packageNamePrefix + PACKAGE_DAO_WITH_BASE + this.fjTable.getClassName() + "DaoTest");
        }
        catch (JClassAlreadyExistsException e) {
            String msg = "fjTable dao test class\uff1a" + this.fjTable.getName() + " is already exists.";
            this.log.error(msg, (Throwable)e);
            throw new CodeGException("CG504", msg, (Exception)((Object)e));
        }
        daoTestClass._extends(this.cmTest.ref("com.fastjrun.test.AbstractAdVancedTestNGSpringContextTest"));
        this.addClassDeclaration(daoTestClass);
        JFieldVar fieldVar = daoTestClass.field(4, (AbstractJType)this.daoClass, "base" + this.fjTable.getClassName() + "Dao");
        fieldVar.annotate(this.cmTest.ref("org.springframework.beans.factory.annotation.Autowired"));
        mybatisDaoTestMethodGenerator.setDaoTestClass(daoTestClass);
        mybatisDaoTestMethodGenerator.setFieldVar(fieldVar);
    }

    protected void processDao() {
        String lowerCaseFirstOneClassName = StringHelper.toLowerCaseFirstOne((String)this.fjTable.getClassName());
        try {
            this.daoClass = this.cm._class(this.packageNamePrefix + PACKAGE_DAO_WITH_BASE + this.fjTable.getClassName() + "Dao", EClassType.INTERFACE);
        }
        catch (JClassAlreadyExistsException e) {
            String msg = "fjTable dao class\uff1a" + this.fjTable.getName() + " is already exists.";
            this.log.error(msg, (Throwable)e);
            throw new CodeGException("CG504", msg, (Exception)((Object)e));
        }
        this.addClassDeclaration(this.daoClass);
        SqlHelper sqlHelper = SQLHelperFactory.getSQLHelper("mysql", this.fjTable);
        JMethod insertMethod = this.daoClass.method(0, (AbstractJType)this.cm.INT, "insert");
        insertMethod.param((AbstractJType)this.entityClass, lowerCaseFirstOneClassName);
        insertMethod.annotate(this.cm.ref("org.apache.ibatis.annotations.Insert")).param("value", sqlHelper.getInsert());
        List<String> primaryKeyColumnNames = this.fjTable.getPrimaryKeyColumnNames();
        if (primaryKeyColumnNames != null) {
            FJColumn fjColumn;
            if (primaryKeyColumnNames.size() == 1 && (fjColumn = this.fjTable.getColumns().get(primaryKeyColumnNames.get(0))).isIdentity()) {
                insertMethod.annotate(this.cm.ref("org.apache.ibatis.annotations.Options")).param("useGeneratedKeys", true).param("keyProperty", fjColumn.getFieldName());
            }
            JMethod selectByPKMethod = this.daoClass.method(0, (AbstractJType)this.entityClass, "selectByPK");
            selectByPKMethod.annotate(this.cm.ref("org.apache.ibatis.annotations.Select")).param("value", sqlHelper.getSelectByPK());
            this.processFlushCache(selectByPKMethod);
            JMethod deleteByPKMethod = this.daoClass.method(0, (AbstractJType)this.cm.INT, "deleteByPK");
            deleteByPKMethod.annotate(this.cm.ref("org.apache.ibatis.annotations.Delete")).param("value", sqlHelper.getDeleteByPK());
            JMethod updateByPKMethod = this.daoClass.method(0, (AbstractJType)this.cm.INT, "updateByPK");
            updateByPKMethod.annotate(this.cm.ref("org.apache.ibatis.annotations.Update")).param("value", sqlHelper.getUpdateByPK());
            updateByPKMethod.param((AbstractJType)this.entityClass, lowerCaseFirstOneClassName);
            for (int i = 0; i < primaryKeyColumnNames.size(); ++i) {
                String key = primaryKeyColumnNames.get(i);
                FJColumn fjColumn2 = this.fjTable.getColumns().get(key);
                String fieldName = fjColumn2.getFieldName();
                JVar selectFieldNameParam = selectByPKMethod.param((AbstractJType)this.cm.ref(fjColumn2.getDatatype()), fieldName);
                selectFieldNameParam.annotate(this.cm.ref("org.apache.ibatis.annotations.Param")).param("value", fieldName);
                JVar deleteFieldNameParam = deleteByPKMethod.param((AbstractJType)this.cm.ref(fjColumn2.getDatatype()), fieldName);
                deleteFieldNameParam.annotate(this.cm.ref("org.apache.ibatis.annotations.Param")).param("value", fieldName);
            }
        }
        JMethod totalCountMethod = this.daoClass.method(0, (AbstractJType)this.cm.INT, "totalCount");
        totalCountMethod.annotate(this.cm.ref("org.apache.ibatis.annotations.Select")).param("value", sqlHelper.getTotalCount(0));
        JMethod queryForListMethod = this.daoClass.method(0, (AbstractJType)this.cm.ref("java.util.List").narrow((AbstractJClass)this.entityClass), "queryForList");
        queryForListMethod.annotate(this.cm.ref("org.apache.ibatis.annotations.Select")).param("value", sqlHelper.getQueryForList(0));
        this.processFlushCache(queryForListMethod);
        JMethod queryForLimitListMethod = this.daoClass.method(0, (AbstractJType)this.cm.ref("java.util.List").narrow((AbstractJClass)this.entityClass), "queryForLimitList");
        queryForLimitListMethod.param((AbstractJType)this.cm.ref("org.apache.ibatis.session.RowBounds"), "rowBounds");
        queryForLimitListMethod.annotate(this.cm.ref("org.apache.ibatis.annotations.Select")).param("value", sqlHelper.getQueryForList(0));
        this.processFlushCache(queryForLimitListMethod);
        JMethod totalCountConditionMethod = this.daoClass.method(0, (AbstractJType)this.cm.INT, "totalCountCondition");
        totalCountConditionMethod.annotate(this.cm.ref("org.apache.ibatis.annotations.SelectProvider")).param("type", (AbstractJType)this.sqlBuilderClass).param("method", "totalCountCondition");
        JVar conditionVar = totalCountConditionMethod.param((AbstractJType)this.cm.ref(String.class), "condition");
        conditionVar.annotate(this.cm.ref("org.apache.ibatis.annotations.Param")).param("value", "condition");
        JMethod selectOneConditionMethod = this.daoClass.method(0, (AbstractJType)this.entityClass, "selectOneCondition");
        selectOneConditionMethod.annotate(this.cm.ref("org.apache.ibatis.annotations.SelectProvider")).param("type", (AbstractJType)this.sqlBuilderClass).param("method", "queryWithCondition");
        conditionVar = selectOneConditionMethod.param((AbstractJType)this.cm.ref("String"), "condition");
        conditionVar.annotate(this.cm.ref("org.apache.ibatis.annotations.Param")).param("value", "condition");
        JMethod queryForListConditionMethod = this.daoClass.method(0, (AbstractJType)this.cm.ref("java.util.List").narrow((AbstractJClass)this.entityClass), "queryForListCondition");
        queryForListConditionMethod.annotate(this.cm.ref("org.apache.ibatis.annotations.SelectProvider")).param("type", (AbstractJType)this.sqlBuilderClass).param("method", "queryWithCondition");
        conditionVar = queryForListConditionMethod.param((AbstractJType)this.cm.ref("String"), "condition");
        conditionVar.annotate(this.cm.ref("org.apache.ibatis.annotations.Param")).param("value", "condition");
        JMethod queryForLimitListConditionMethod = this.daoClass.method(0, (AbstractJType)this.cm.ref("java.util.List").narrow((AbstractJClass)this.entityClass), "queryForLImitListCondition");
        queryForLimitListConditionMethod.annotate(this.cm.ref("org.apache.ibatis.annotations.SelectProvider")).param("type", (AbstractJType)this.sqlBuilderClass).param("method", "queryWithCondition");
        conditionVar = queryForLimitListConditionMethod.param((AbstractJType)this.cm.ref("String"), "condition");
        conditionVar.annotate(this.cm.ref("org.apache.ibatis.annotations.Param")).param("value", "condition");
        queryForLimitListConditionMethod.param((AbstractJType)this.cm.ref("org.apache.ibatis.session.RowBounds"), "rowBounds");
        JMethod insertAllMethod = this.daoClass.method(0, (AbstractJType)this.cm.INT, "insertAll");
        insertAllMethod.param((AbstractJType)this.cm.ref("java.util.List").narrow((AbstractJClass)this.entityClass), lowerCaseFirstOneClassName + "s");
        insertAllMethod.annotate(this.cm.ref("org.apache.ibatis.annotations.InsertProvider")).param("type", (AbstractJType)this.sqlBuilderClass).param("method", "insertAll");
    }

    private void processFlushCache(JMethod queryForLimitListMethod) {
        if ("3.5".equals(this.mybatisVersion) || "3.4".equals(this.mybatisVersion)) {
            JAnnotationUse optionsAnnotation = queryForLimitListMethod.annotate(this.cm.ref("org.apache.ibatis.annotations.Options"));
            optionsAnnotation.param("flushCache", (IJExpression)this.cm.ref("org.apache.ibatis.annotations.Options.FlushCachePolicy").staticRef("TRUE"));
        } else {
            queryForLimitListMethod.annotate(this.cm.ref("org.apache.ibatis.annotations.Options")).param("flushCache", true);
        }
    }

    protected void processService() {
        String lowerCaseFirstOneClassName = StringHelper.toLowerCaseFirstOne((String)this.fjTable.getClassName());
        try {
            this.serviceClass = this.cm._class(this.packageNamePrefix + PACKAGE_SERVICE_WITH_BASE + this.fjTable.getClassName() + "Service", EClassType.INTERFACE);
        }
        catch (JClassAlreadyExistsException e) {
            String msg = "fjTable service class\uff1a" + this.fjTable.getName() + " is already exists.";
            this.log.error(msg, (Throwable)e);
            throw new CodeGException("CG504", msg, (Exception)((Object)e));
        }
        this.addClassDeclaration(this.serviceClass);
        JMethod insertMethod = this.serviceClass.method(0, (AbstractJType)this.cm.INT, "insert");
        insertMethod.param((AbstractJType)this.entityClass, lowerCaseFirstOneClassName);
        List<String> primaryKeyColumnNames = this.fjTable.getPrimaryKeyColumnNames();
        if (primaryKeyColumnNames != null) {
            JMethod selectByPKMethod = this.serviceClass.method(0, (AbstractJType)this.entityClass, "selectByPK");
            JMethod deleteByPKMethod = this.serviceClass.method(0, (AbstractJType)this.cm.INT, "deleteByPK");
            JMethod updateByPKMethod = this.serviceClass.method(0, (AbstractJType)this.cm.INT, "updateByPK");
            updateByPKMethod.param((AbstractJType)this.entityClass, lowerCaseFirstOneClassName);
            for (int i = 0; i < primaryKeyColumnNames.size(); ++i) {
                String key = primaryKeyColumnNames.get(i);
                FJColumn fjColumn = this.fjTable.getColumns().get(key);
                String fieldName = fjColumn.getFieldName();
                selectByPKMethod.param((AbstractJType)this.cm.ref(fjColumn.getDatatype()), fieldName);
                deleteByPKMethod.param((AbstractJType)this.cm.ref(fjColumn.getDatatype()), fieldName);
            }
        }
        JMethod totalCountMethod = this.serviceClass.method(0, (AbstractJType)this.cm.INT, "totalCount");
        JMethod queryForLimitListMethod = this.serviceClass.method(0, (AbstractJType)this.cm.ref("java.util.List").narrow((AbstractJClass)this.entityClass), "queryForLimitList");
        queryForLimitListMethod.param((AbstractJType)this.cm.INT, "pageNum");
        queryForLimitListMethod.param((AbstractJType)this.cm.INT, "pageSize");
    }

    protected void processServiceImpl() {
        String lowerCaseFirstOneClassName = StringHelper.toLowerCaseFirstOne((String)this.fjTable.getClassName());
        try {
            this.serviceImplClass = this.cm._class(this.packageNamePrefix + PACKAGE_SERVICE_IMPL_WITH_BASE + this.fjTable.getClassName() + "ServiceImpl");
        }
        catch (JClassAlreadyExistsException e) {
            String msg = "fjTable service impl class\uff1a" + this.fjTable.getName() + " is already exists.";
            this.log.error(msg, (Throwable)e);
            throw new CodeGException("CG504", msg, (Exception)((Object)e));
        }
        this.serviceImplClass._implements((AbstractJClass)this.serviceClass);
        this.serviceImplClass.annotate(this.cm.ref("org.springframework.stereotype.Service")).param("value", "base" + this.fjTable.getClassName() + "Service");
        this.addClassDeclaration(this.serviceImplClass);
        JFieldVar fieldVar = this.serviceImplClass.field(4, (AbstractJType)this.daoClass, "base" + this.fjTable.getClassName() + "Dao");
        fieldVar.annotate(this.cm.ref("org.springframework.beans.factory.annotation.Autowired"));
        JMethod insertMethod = this.serviceImplClass.method(1, (AbstractJType)this.cm.INT, "insert");
        insertMethod.annotate(this.cm.ref("java.lang.Override"));
        JVar insertParamJVar = insertMethod.param((AbstractJType)this.entityClass, lowerCaseFirstOneClassName);
        insertMethod.body()._return((IJExpression)fieldVar.invoke("insert").arg((IJExpression)insertParamJVar));
        List<String> primaryKeyColumnNames = this.fjTable.getPrimaryKeyColumnNames();
        if (primaryKeyColumnNames != null) {
            JMethod selectByPKMethod = this.serviceImplClass.method(1, (AbstractJType)this.entityClass, "selectByPK");
            selectByPKMethod.annotate(this.cm.ref("java.lang.Override"));
            JMethod deleteByPKMethod = this.serviceImplClass.method(1, (AbstractJType)this.cm.INT, "deleteByPK");
            deleteByPKMethod.annotate(this.cm.ref("java.lang.Override"));
            JMethod updateByPKMethod = this.serviceImplClass.method(1, (AbstractJType)this.cm.INT, "updateByPK");
            updateByPKMethod.annotate(this.cm.ref("java.lang.Override"));
            JVar updateByPKParamJVar = updateByPKMethod.param((AbstractJType)this.entityClass, lowerCaseFirstOneClassName);
            updateByPKMethod.body()._return((IJExpression)fieldVar.invoke("updateByPK").arg((IJExpression)updateByPKParamJVar));
            JInvocation jSelectByPKJInvocation = fieldVar.invoke("selectByPK");
            JInvocation jDeleteByPKJInvocation = fieldVar.invoke("deleteByPK");
            for (int i = 0; i < primaryKeyColumnNames.size(); ++i) {
                String key = primaryKeyColumnNames.get(i);
                FJColumn fjColumn = this.fjTable.getColumns().get(key);
                String fieldName = fjColumn.getFieldName();
                JVar selectByPKParamJVar = selectByPKMethod.param((AbstractJType)this.cm.ref(fjColumn.getDatatype()), fieldName);
                jSelectByPKJInvocation.arg((IJExpression)selectByPKParamJVar);
                JVar deleteByPKParamJVar = deleteByPKMethod.param((AbstractJType)this.cm.ref(fjColumn.getDatatype()), fieldName);
                jDeleteByPKJInvocation.arg((IJExpression)deleteByPKParamJVar);
            }
            selectByPKMethod.body()._return((IJExpression)jSelectByPKJInvocation);
            deleteByPKMethod.body()._return((IJExpression)jDeleteByPKJInvocation);
        }
        JMethod totalCountMethod = this.serviceImplClass.method(1, (AbstractJType)this.cm.INT, "totalCount");
        totalCountMethod.annotate(this.cm.ref("java.lang.Override"));
        totalCountMethod.body()._return((IJExpression)fieldVar.invoke("totalCount"));
        JMethod queryForLimitListMethod = this.serviceImplClass.method(1, (AbstractJType)this.cm.ref("java.util.List").narrow((AbstractJClass)this.entityClass), "queryForLimitList");
        queryForLimitListMethod.annotate(this.cm.ref("java.lang.Override"));
        JVar pageNumJVar = queryForLimitListMethod.param((AbstractJType)this.cm.INT, "pageNum");
        JVar pageSizeJVar = queryForLimitListMethod.param((AbstractJType)this.cm.INT, "pageSize");
        JBlock queryForLimitListMethodBlk = queryForLimitListMethod.body();
        JVar rowBoundsJVar = queryForLimitListMethodBlk.decl((AbstractJType)this.cm.ref("org.apache.ibatis.session.RowBounds"), "rowBounds", (IJExpression)JExpr._new((AbstractJType)this.cm.ref("org.apache.ibatis.session.RowBounds")).arg(pageNumJVar.minus((IJExpression)JExpr.lit((int)1)).mul((IJExpression)pageSizeJVar)).arg(pageNumJVar.mul((IJExpression)pageSizeJVar).minus((IJExpression)JExpr.lit((int)1))));
        queryForLimitListMethodBlk._return((IJExpression)fieldVar.invoke("queryForLimitList").arg((IJExpression)rowBoundsJVar));
    }

    private void processSQLBuilder() {
        String lowerCaseFirstOneClassName = StringHelper.toLowerCaseFirstOne((String)this.fjTable.getClassName());
        try {
            this.sqlBuilderClass = this.cm._class(this.packageNamePrefix + PACKAGE_DAO_WITH_BASE + this.fjTable.getClassName() + "SqlBuilder");
        }
        catch (JClassAlreadyExistsException e) {
            String msg = "fjTable SqlBuilder class\uff1a" + this.fjTable.getName() + " is already exists.";
            this.log.error(msg, (Throwable)e);
            throw new CodeGException("CG504", msg, (Exception)((Object)e));
        }
        SqlHelper sqlHelper = SQLHelperFactory.getSQLHelper("mysql", this.fjTable);
        JMethod totalCountConditionMethod = this.sqlBuilderClass.method(1, (AbstractJType)this.cm.ref("String"), "totalCountCondition");
        JVar parameterVar = totalCountConditionMethod.param((AbstractJType)this.cm.ref("java.util.Map").narrow(String.class).narrow(String.class), "parameter");
        JBlock totalCountConditionMethodBlk = totalCountConditionMethod.body();
        JVar totalCountConditionVar = totalCountConditionMethodBlk.decl((AbstractJType)this.cm.ref("String"), "condition", (IJExpression)parameterVar.invoke("get").arg("condition"));
        JVar totalCountConditionSbVar = totalCountConditionMethodBlk.decl((AbstractJType)this.cm.ref("StringBuilder"), "sb", (IJExpression)JExpr._new((AbstractJType)this.cm.ref("StringBuilder")));
        totalCountConditionMethodBlk.add((IJStatement)totalCountConditionSbVar.invoke("append").arg(sqlHelper.getTotalCount(1)));
        totalCountConditionMethodBlk.add((IJStatement)totalCountConditionSbVar.invoke("append").arg((IJExpression)totalCountConditionVar));
        totalCountConditionMethodBlk._return((IJExpression)totalCountConditionSbVar.invoke("toString"));
        JMethod queryWithConditionMethod = this.sqlBuilderClass.method(1, (AbstractJType)this.cm.ref("String"), "queryWithCondition");
        parameterVar = queryWithConditionMethod.param((AbstractJType)this.cm.ref("java.util.Map").narrow(String.class).narrow(String.class), "parameter");
        JBlock queryWithConditionMethodBlk = queryWithConditionMethod.body();
        JVar queryWithConditionVar = queryWithConditionMethodBlk.decl((AbstractJType)this.cm.ref("String"), "condition", (IJExpression)parameterVar.invoke("get").arg("condition"));
        JVar queryWithConditionBbVar = queryWithConditionMethodBlk.decl((AbstractJType)this.cm.ref("StringBuilder"), "sb", (IJExpression)JExpr._new((AbstractJType)this.cm.ref("StringBuilder")));
        queryWithConditionMethodBlk.add((IJStatement)queryWithConditionBbVar.invoke("append").arg(sqlHelper.getQueryForList(1)));
        queryWithConditionMethodBlk.add((IJStatement)queryWithConditionBbVar.invoke("append").arg((IJExpression)queryWithConditionVar));
        queryWithConditionMethodBlk._return((IJExpression)queryWithConditionBbVar.invoke("toString"));
        JMethod insertAllMethod = this.sqlBuilderClass.method(1, (AbstractJType)this.cm.ref("String"), "insertAll");
        parameterVar = insertAllMethod.param((AbstractJType)this.cm.ref("java.util.Map").narrow(this.cm.ref("String")).narrow((AbstractJClass)this.cm.ref("java.util.List").narrow((AbstractJClass)this.entityClass)), "parameter");
        JBlock insertAllMethodBlk = insertAllMethod.body();
        JVar insertAllParameterVar = insertAllMethodBlk.decl((AbstractJType)this.cm.ref("java.util.List").narrow((AbstractJClass)this.entityClass), lowerCaseFirstOneClassName + "s", (IJExpression)parameterVar.invoke("get").arg(lowerCaseFirstOneClassName + "s"));
        JVar insertAllSbVar = insertAllMethodBlk.decl((AbstractJType)this.cm.ref("StringBuilder"), "sb", (IJExpression)JExpr._new((AbstractJType)this.cm.ref("StringBuilder")));
        String[] sqlParamAndValue = this.getAllFieldsForBatch(this.fjTable);
        JVar messageFormatVar = insertAllMethodBlk.decl((AbstractJType)this.cm.ref("java.text.MessageFormat"), "messageFormat", (IJExpression)JExpr._new((AbstractJType)this.cm.ref("java.text.MessageFormat")).arg(sqlParamAndValue[1]));
        if (sqlHelper instanceof MysqlSqlHelper) {
            insertAllMethodBlk.add((IJStatement)insertAllSbVar.invoke("append").arg("INSERT INTO " + this.fjTable.getName() + sqlParamAndValue[0] + " VALUES"));
            JForLoop forLoop = insertAllMethodBlk._for();
            JVar i = forLoop.init((AbstractJType)this.cm.INT, "i", (IJExpression)JExpr.lit((int)0));
            forLoop.test(i.lt((IJExpression)insertAllParameterVar.invoke("size")));
            forLoop.update(i.incr());
            JBlock forBlk = forLoop.body();
            forBlk.add((IJStatement)JExpr.ref((String)"sb").invoke("append").arg((IJExpression)messageFormatVar.invoke("format").arg((IJExpression)JExpr.newArray((AbstractJType)this.cm.ref("java.lang.Object")).add((IJExpression)JExpr.ref((String)"i")))));
            JConditional jif = forBlk._if(JExpr.ref((String)"i").lt(insertAllParameterVar.invoke("size").minus((IJExpression)JExpr.lit((int)1))));
            JBlock ifBlk = jif._then();
            ifBlk.add((IJStatement)JExpr.ref((String)"sb").invoke("append").arg(","));
        } else {
            insertAllMethodBlk.add((IJStatement)insertAllSbVar.invoke("append").arg("INSERT INTO " + this.fjTable.getName() + sqlParamAndValue[0] + " "));
            JForLoop forLoop = insertAllMethodBlk._for();
            JVar i = forLoop.init((AbstractJType)this.cm.INT, "i", (IJExpression)JExpr.lit((int)0));
            forLoop.test(i.lt((IJExpression)insertAllParameterVar.invoke("size")));
            forLoop.update(i.incr());
            JBlock forBlk = forLoop.body();
            forBlk.add((IJStatement)JExpr.ref((String)"sb").invoke("append").arg("SELECT "));
            forBlk.add((IJStatement)JExpr.ref((String)"sb").invoke("append").arg((IJExpression)messageFormatVar.invoke("format").arg((IJExpression)JExpr.newArray((AbstractJType)this.cm.ref("java.lang.Object")).add((IJExpression)JExpr.ref((String)"i")))));
            forBlk.add((IJStatement)JExpr.ref((String)"sb").invoke("append").arg(" FROM DUAL "));
            JConditional jif = forBlk._if(JExpr.ref((String)"i").lt(insertAllParameterVar.invoke("size").minus((IJExpression)JExpr.lit((int)1))));
            JBlock ifBlk = jif._then();
            ifBlk.add((IJStatement)JExpr.ref((String)"sb").invoke("append").arg(" UNION ALL "));
        }
        insertAllMethodBlk._return((IJExpression)insertAllSbVar.invoke("toString"));
    }

    private String[] getAllFieldsForBatch(FJTable FJTable2) {
        StringBuilder sqlParam = new StringBuilder("(");
        StringBuilder sqlValue = new StringBuilder("(");
        Map<String, FJColumn> columns = FJTable2.getColumns();
        int i = 0;
        for (FJColumn fjColumn : columns.values()) {
            String name = fjColumn.getName();
            if (fjColumn.isIdentity()) continue;
            if (i > 0) {
                sqlParam.append(",");
                sqlValue.append(",");
            }
            sqlParam.append("`").append(name).append("`");
            sqlValue.append("#'{'list[{0}].").append(fjColumn.getFieldName()).append("}");
            ++i;
        }
        sqlParam.append(")");
        sqlValue.append(")");
        return new String[]{sqlParam.toString(), sqlValue.toString()};
    }

    @Override
    public void generate() {
        this.processEntity();
        this.processSQLBuilder();
        this.processDao();
        this.processService();
        this.processServiceImpl();
        if (this.isSupportTest()) {
            MybatisDaoTestMethodGenerator mybatisDaoTestMethodGenerator = new MybatisDaoTestMethodGenerator();
            mybatisDaoTestMethodGenerator.setCmTest(this.cmTest);
            mybatisDaoTestMethodGenerator.setEntityClass((AbstractJClass)this.entityClass);
            mybatisDaoTestMethodGenerator.setFjTable(this.fjTable);
            this.processDaoTest(mybatisDaoTestMethodGenerator);
            mybatisDaoTestMethodGenerator.generate();
            this.daoTestParam = mybatisDaoTestMethodGenerator.getDaoTestParam();
        }
    }
}

