/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.codeg.generator;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fastjrun.codeg.common.FJColumn;
import com.fastjrun.codeg.common.FJTable;
import com.fastjrun.codeg.generator.common.BaseCMGenerator;
import com.fastjrun.codeg.generator.common.MybatisAFDaoConstants;
import com.fastjrun.helper.StringHelper;
import com.fastjrun.utils.JacksonUtils;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JForLoop;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.List;
import java.util.Properties;

public class MybatisDaoTestMethodGenerator
extends BaseCMGenerator
implements MybatisAFDaoConstants {
    protected FJTable fjTable;
    protected AbstractJClass entityClass;
    protected JFieldVar fieldVar;
    protected JDefinedClass daoTestClass;
    protected Properties daoTestParam;
    private String lowerCaseFirstOneClassName;

    public Properties getDaoTestParam() {
        return this.daoTestParam;
    }

    public void setDaoTestParam(Properties daoTestParam) {
        this.daoTestParam = daoTestParam;
    }

    public AbstractJClass getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(AbstractJClass entityClass) {
        this.entityClass = entityClass;
    }

    public FJTable getFjTable() {
        return this.fjTable;
    }

    public void setFjTable(FJTable fjTable) {
        this.fjTable = fjTable;
    }

    public JDefinedClass getDaoTestClass() {
        return this.daoTestClass;
    }

    public void setDaoTestClass(JDefinedClass daoTestClass) {
        this.daoTestClass = daoTestClass;
    }

    public JFieldVar getFieldVar() {
        return this.fieldVar;
    }

    public void setFieldVar(JFieldVar fieldVar) {
        this.fieldVar = fieldVar;
    }

    protected void processInsert() {
        JMethod method = this.prepareMethod("insert");
        JBlock methodBlk = method.body();
        JVar reqParamsJsonStrAndAssertJVar = method.param((AbstractJType)this.cmTest.ref("String"), "reqParamsJsonStrAndAssert");
        JVar paramsJsonJVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "paramsJson", (IJExpression)JExpr._this().invoke("parseStr2JsonArray").arg((IJExpression)reqParamsJsonStrAndAssertJVar).component(0));
        JVar entityVar = methodBlk.decl((AbstractJType)this.entityClass, this.lowerCaseFirstOneClassName, (IJExpression)JExpr._null());
        JVar entityStrVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), this.lowerCaseFirstOneClassName + "Json", (IJExpression)paramsJsonJVar.invoke("get").arg((IJExpression)JExpr.lit((String)this.lowerCaseFirstOneClassName)));
        JBlock jNotNullBlock = methodBlk._if(entityStrVar.ne((IJExpression)JExpr._null()))._then();
        jNotNullBlock.assign((IJAssignmentTarget)entityVar, (IJExpression)this.cmTest.ref("com.fastjrun.utils.JacksonUtils").staticInvoke("readValue").arg((IJExpression)paramsJsonJVar.invoke("toString")).arg(this.entityClass.dotclass()));
        JInvocation jInvocationTest = JExpr.invoke((IJExpression)this.fieldVar, (String)"insert").arg((IJExpression)entityVar);
        ObjectNode methodParamInJsonObject = JacksonUtils.createObjectNode();
        methodParamInJsonObject.put(this.lowerCaseFirstOneClassName, this.fjTable.parseDescToJson());
        this.putIntoTestParam(methodParamInJsonObject, "insert");
        JVar resJVar = methodBlk.decl((AbstractJType)this.cmTest.INT, "res", (IJExpression)jInvocationTest);
        methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"res={}")).arg((IJExpression)resJVar));
    }

    private void putIntoTestParam(ObjectNode methodParamInJsonObject, String methodName) {
        StringBuilder sb = new StringBuilder(this.daoTestClass.name()).append(".test").append(StringHelper.toUpperCaseFirstOne((String)methodName)).append(".n");
        this.daoTestParam.put(sb.toString(), methodParamInJsonObject.toString().replaceAll("\n", "").replaceAll("\r", "").trim());
    }

    protected void processSelectByPK() {
        List<String> primaryKeyColumnNames = this.fjTable.getPrimaryKeyColumnNames();
        JInvocation jInvocationTest = JExpr.invoke((IJExpression)this.fieldVar, (String)"selectByPK");
        JBlock methodBlk = this.processMethod("selectByPK", primaryKeyColumnNames, jInvocationTest);
        JVar entityJVar = methodBlk.decl((AbstractJType)this.entityClass, this.lowerCaseFirstOneClassName, (IJExpression)jInvocationTest);
        methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)(this.lowerCaseFirstOneClassName + "={}"))).arg((IJExpression)entityJVar));
    }

    private JBlock processMethod(String methodName, List<String> primaryKeyColumnNames, JInvocation jInvocationTest) {
        JMethod method = this.prepareMethod(methodName);
        JBlock methodBlk = method.body();
        JVar reqParamsJsonStrAndAssertJVar = method.param((AbstractJType)this.cmTest.ref("String"), "reqParamsJsonStrAndAssert");
        JVar paramsJsonJVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "paramsJson", (IJExpression)JExpr._this().invoke("parseStr2JsonArray").arg((IJExpression)reqParamsJsonStrAndAssertJVar).component(0));
        ObjectNode methodParamInJsonObject = JacksonUtils.createObjectNode();
        for (int i = 0; i < primaryKeyColumnNames.size(); ++i) {
            String key = primaryKeyColumnNames.get(i);
            FJColumn fjColumn = this.fjTable.getColumns().get(key);
            String fieldName = fjColumn.getFieldName();
            AbstractJClass jType = this.cmTest.ref(fjColumn.getDatatype());
            methodParamInJsonObject.put(fieldName, jType.name());
            JVar selectFieldVar = methodBlk.decl((AbstractJType)jType, fieldName, (IJExpression)JExpr._null());
            JVar selectFieldStrVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), fieldName + "Json", (IJExpression)paramsJsonJVar.invoke("get").arg((IJExpression)JExpr.lit((String)fieldName)));
            String jsonInvokeMethodName = JacksonUtils.invokeMethodName((String)jType.name());
            JBlock jNotNullBlock = methodBlk._if(selectFieldStrVar.ne((IJExpression)JExpr._null()))._then();
            jNotNullBlock.assign((IJAssignmentTarget)selectFieldVar, (IJExpression)selectFieldStrVar.invoke(jsonInvokeMethodName));
            jInvocationTest.arg((IJExpression)selectFieldVar);
        }
        this.putIntoTestParam(methodParamInJsonObject, methodName);
        return methodBlk;
    }

    private JMethod prepareMethod(String methodName) {
        JMethod method = this.daoTestClass.method(0, (AbstractJType)this.cmTest.VOID, "test" + StringHelper.toUpperCaseFirstOne((String)methodName));
        JAnnotationUse jAnnotationUse = method.annotate(this.cmTest.ref("org.testng.annotations.Test"));
        jAnnotationUse.param("dataProvider", "loadParam");
        return method;
    }

    protected void processUpdateByPK() {
        JMethod method = this.prepareMethod("updateByPK");
        JBlock methodBlk = method.body();
        JVar reqParamsJsonStrAndAssertJVar = method.param((AbstractJType)this.cmTest.ref("String"), "reqParamsJsonStrAndAssert");
        JVar paramsJsonJVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "paramsJson", (IJExpression)JExpr._this().invoke("parseStr2JsonArray").arg((IJExpression)reqParamsJsonStrAndAssertJVar).component(0));
        JVar entityVar = methodBlk.decl((AbstractJType)this.entityClass, this.lowerCaseFirstOneClassName, (IJExpression)JExpr._null());
        JVar entityStrVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), this.lowerCaseFirstOneClassName + "Json", (IJExpression)paramsJsonJVar.invoke("get").arg((IJExpression)JExpr.lit((String)this.lowerCaseFirstOneClassName)));
        JBlock jNotNullBlock = methodBlk._if(entityStrVar.ne((IJExpression)JExpr._null()))._then();
        jNotNullBlock.assign((IJAssignmentTarget)entityVar, (IJExpression)this.cmTest.ref("com.fastjrun.utils.JacksonUtils").staticInvoke("readValue").arg((IJExpression)paramsJsonJVar.invoke("toString")).arg(this.entityClass.dotclass()));
        JInvocation jInvocationTest = JExpr.invoke((IJExpression)this.fieldVar, (String)"updateByPK").arg((IJExpression)entityVar);
        ObjectNode methodParamInJsonObject = JacksonUtils.createObjectNode();
        methodParamInJsonObject.put(this.lowerCaseFirstOneClassName, this.fjTable.parseDescToJson());
        this.putIntoTestParam(methodParamInJsonObject, "updateByPK");
        JVar resJVar = methodBlk.decl((AbstractJType)this.cmTest.INT, "res", (IJExpression)jInvocationTest);
        methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"res={}")).arg((IJExpression)resJVar));
    }

    protected void processDeleteByPK() {
        List<String> primaryKeyColumnNames = this.fjTable.getPrimaryKeyColumnNames();
        JInvocation jInvocationTest = JExpr.invoke((IJExpression)this.fieldVar, (String)"deleteByPK");
        JBlock methodBlk = this.processMethod("deleteByPK", primaryKeyColumnNames, jInvocationTest);
        JVar resJVar = methodBlk.decl((AbstractJType)this.cmTest.INT, "res", (IJExpression)jInvocationTest);
        methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"res={}")).arg((IJExpression)resJVar));
    }

    protected void processTotalCount() {
        JMethod method = this.prepareMethod("totalCount");
        JBlock methodBlk = method.body();
        method.param((AbstractJType)this.cmTest.ref("String"), "reqParamsJsonStrAndAssert");
        JInvocation jInvocationTest = JExpr.invoke((IJExpression)this.fieldVar, (String)"totalCount");
        ObjectNode methodParamInJsonObject = JacksonUtils.createObjectNode();
        this.putIntoTestParam(methodParamInJsonObject, "totalCount");
        JVar resJVar = methodBlk.decl((AbstractJType)this.cmTest.INT, "res", (IJExpression)jInvocationTest);
        methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"res={}")).arg((IJExpression)resJVar));
    }

    protected void processQueryForList() {
        JMethod method = this.prepareMethod("queryForList");
        JBlock methodBlk = method.body();
        method.param((AbstractJType)this.cmTest.ref("String"), "reqParamsJsonStrAndAssert");
        JInvocation jInvocationTest = JExpr.invoke((IJExpression)this.fieldVar, (String)"queryForList");
        ObjectNode methodParamInJsonObject = JacksonUtils.createObjectNode();
        this.putIntoTestParam(methodParamInJsonObject, "queryForList");
        JVar listJVar = methodBlk.decl((AbstractJType)this.cmTest.ref("java.util.List").narrow(this.entityClass), "list", (IJExpression)jInvocationTest);
        JBlock jNotNullBlock = methodBlk._if(listJVar.ne((IJExpression)JExpr._null()))._then();
        JForLoop forLoop = jNotNullBlock._for();
        JVar initIndexVar = forLoop.init((AbstractJType)this.cmTest.INT, "index", (IJExpression)JExpr.lit((int)0));
        forLoop.test(initIndexVar.lt((IJExpression)listJVar.invoke("size")));
        forLoop.update(initIndexVar.incr());
        JBlock forBlock1 = forLoop.body();
        JVar itemIndexVar = forBlock1.decl((AbstractJType)this.entityClass, this.lowerCaseFirstOneClassName, (IJExpression)listJVar.invoke("get").arg((IJExpression)initIndexVar));
        forBlock1.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)(this.lowerCaseFirstOneClassName + "{}={}"))).arg((IJExpression)initIndexVar).arg((IJExpression)itemIndexVar));
    }

    protected void processQueryForLimitList() {
        JMethod method = this.prepareMethod("queryForLimitList");
        JBlock methodBlk = method.body();
        JVar reqParamsJsonStrAndAssertJVar = method.param((AbstractJType)this.cmTest.ref("String"), "reqParamsJsonStrAndAssert");
        JVar paramsJsonJVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "paramsJson", (IJExpression)JExpr._this().invoke("parseStr2JsonArray").arg((IJExpression)reqParamsJsonStrAndAssertJVar).component(0));
        JVar rowBoundsVar = methodBlk.decl((AbstractJType)this.cmTest.ref("org.apache.ibatis.session.RowBounds"), "rowBounds", (IJExpression)JExpr._null());
        JVar rowBoundsStrVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "rowBoundsJson", (IJExpression)paramsJsonJVar.invoke("get").arg((IJExpression)JExpr.lit((String)"rowBounds")));
        JBlock jNotNullBlock = methodBlk._if(rowBoundsStrVar.ne((IJExpression)JExpr._null()))._then();
        jNotNullBlock.assign((IJAssignmentTarget)rowBoundsVar, (IJExpression)this.cmTest.ref("com.fastjrun.utils.JacksonUtils").staticInvoke("readValue").arg((IJExpression)rowBoundsStrVar.invoke("toString")).arg(this.cmTest.ref("org.apache.ibatis.session.RowBounds").dotclass()));
        JInvocation jInvocationTest = JExpr.invoke((IJExpression)this.fieldVar, (String)"queryForLimitList").arg((IJExpression)rowBoundsVar);
        ObjectNode methodParamInJsonObject = JacksonUtils.createObjectNode();
        ObjectNode rowBoundsInJsonObject = JacksonUtils.createObjectNode();
        rowBoundsInJsonObject.put("offset", "int");
        rowBoundsInJsonObject.put("limit", "int");
        methodParamInJsonObject.put("rowBounds", rowBoundsInJsonObject.toString());
        this.putIntoTestParam(methodParamInJsonObject, "queryForLimitList");
        JVar listJVar = methodBlk.decl((AbstractJType)this.cmTest.ref("java.util.List").narrow(this.entityClass), "list", (IJExpression)jInvocationTest);
        jNotNullBlock = methodBlk._if(listJVar.ne((IJExpression)JExpr._null()))._then();
        JForLoop forLoop = jNotNullBlock._for();
        JVar initIndexVar = forLoop.init((AbstractJType)this.cmTest.INT, "index", (IJExpression)JExpr.lit((int)0));
        forLoop.test(initIndexVar.lt((IJExpression)listJVar.invoke("size")));
        forLoop.update(initIndexVar.incr());
        JBlock forBlock1 = forLoop.body();
        JVar itemIndexVar = forBlock1.decl((AbstractJType)this.entityClass, this.lowerCaseFirstOneClassName, (IJExpression)listJVar.invoke("get").arg((IJExpression)initIndexVar));
        forBlock1.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)(this.lowerCaseFirstOneClassName + "{}={}"))).arg((IJExpression)initIndexVar).arg((IJExpression)itemIndexVar));
    }

    protected void processTotalCountCondition() {
        JMethod method = this.prepareMethod("totalCountCondition");
        JBlock methodBlk = method.body();
        JVar reqParamsJsonStrAndAssertJVar = method.param((AbstractJType)this.cmTest.ref("String"), "reqParamsJsonStrAndAssert");
        JVar paramsJsonJVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "paramsJson", (IJExpression)JExpr._this().invoke("parseStr2JsonArray").arg((IJExpression)reqParamsJsonStrAndAssertJVar).component(0));
        JVar conditionVar = methodBlk.decl((AbstractJType)this.cmTest.ref("String"), "condition", (IJExpression)JExpr._null());
        JVar conditionStrVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "conditionJson", (IJExpression)paramsJsonJVar.invoke("get").arg((IJExpression)JExpr.lit((String)"condition")));
        JBlock jNotNullBlock = methodBlk._if(conditionStrVar.ne((IJExpression)JExpr._null()))._then();
        jNotNullBlock.assign((IJAssignmentTarget)conditionVar, (IJExpression)conditionStrVar.invoke("asText"));
        JInvocation jInvocationTest = JExpr.invoke((IJExpression)this.fieldVar, (String)"totalCountCondition").arg((IJExpression)conditionVar);
        ObjectNode methodParamInJsonObject = JacksonUtils.createObjectNode();
        methodParamInJsonObject.put("condition", "String");
        this.putIntoTestParam(methodParamInJsonObject, "totalCountCondition");
        JVar resJVar = methodBlk.decl((AbstractJType)this.cmTest.INT, "res", (IJExpression)jInvocationTest);
        methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"res={}")).arg((IJExpression)resJVar));
    }

    protected void processSelectOneCondition() {
        JMethod method = this.prepareMethod("selectOneCondition");
        JBlock methodBlk = method.body();
        JVar reqParamsJsonStrAndAssertJVar = method.param((AbstractJType)this.cmTest.ref("String"), "reqParamsJsonStrAndAssert");
        JVar paramsJsonJVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "paramsJson", (IJExpression)JExpr._this().invoke("parseStr2JsonArray").arg((IJExpression)reqParamsJsonStrAndAssertJVar).component(0));
        JVar conditionVar = methodBlk.decl((AbstractJType)this.cmTest.ref("String"), "condition", (IJExpression)JExpr._null());
        JVar conditionStrVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "conditionJson", (IJExpression)paramsJsonJVar.invoke("get").arg((IJExpression)JExpr.lit((String)"condition")));
        JBlock jNotNullBlock = methodBlk._if(conditionStrVar.ne((IJExpression)JExpr._null()))._then();
        jNotNullBlock.assign((IJAssignmentTarget)conditionVar, (IJExpression)conditionStrVar.invoke("asText"));
        JInvocation jInvocationTest = JExpr.invoke((IJExpression)this.fieldVar, (String)"selectOneCondition").arg((IJExpression)conditionVar);
        ObjectNode methodParamInJsonObject = JacksonUtils.createObjectNode();
        methodParamInJsonObject.put("condition", "String");
        this.putIntoTestParam(methodParamInJsonObject, "selectOneCondition");
        JVar entityJVar = methodBlk.decl((AbstractJType)this.entityClass, this.lowerCaseFirstOneClassName, (IJExpression)jInvocationTest);
        methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)(this.lowerCaseFirstOneClassName + "={}"))).arg((IJExpression)entityJVar));
    }

    protected void processQueryForListCondition() {
        JMethod method = this.prepareMethod("queryForListCondition");
        JBlock methodBlk = method.body();
        JVar reqParamsJsonStrAndAssertJVar = method.param((AbstractJType)this.cmTest.ref("String"), "reqParamsJsonStrAndAssert");
        JVar paramsJsonJVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "paramsJson", (IJExpression)JExpr._this().invoke("parseStr2JsonArray").arg((IJExpression)reqParamsJsonStrAndAssertJVar).component(0));
        JVar conditionVar = methodBlk.decl((AbstractJType)this.cmTest.ref("String"), "condition", (IJExpression)JExpr._null());
        JVar conditionStrVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "conditionJson", (IJExpression)paramsJsonJVar.invoke("get").arg("condition"));
        JBlock jNotNullBlock = methodBlk._if(conditionStrVar.ne((IJExpression)JExpr._null()))._then();
        jNotNullBlock.assign((IJAssignmentTarget)conditionVar, (IJExpression)conditionStrVar.invoke("asText"));
        JInvocation jInvocationTest = JExpr.invoke((IJExpression)this.fieldVar, (String)"queryForListCondition").arg((IJExpression)conditionVar);
        ObjectNode methodParamInJsonObject = JacksonUtils.createObjectNode();
        methodParamInJsonObject.put("condition", "String");
        this.putIntoTestParam(methodParamInJsonObject, "queryForListCondition");
        JVar listJVar = methodBlk.decl((AbstractJType)this.cmTest.ref("java.util.List").narrow(this.entityClass), "list", (IJExpression)jInvocationTest);
        jNotNullBlock = methodBlk._if(listJVar.ne((IJExpression)JExpr._null()))._then();
        JForLoop forLoop = jNotNullBlock._for();
        JVar initIndexVar = forLoop.init((AbstractJType)this.cmTest.INT, "index", (IJExpression)JExpr.lit((int)0));
        forLoop.test(initIndexVar.lt((IJExpression)listJVar.invoke("size")));
        forLoop.update(initIndexVar.incr());
        JBlock forBlock1 = forLoop.body();
        JVar itemIndexVar = forBlock1.decl((AbstractJType)this.entityClass, this.lowerCaseFirstOneClassName, (IJExpression)listJVar.invoke("get").arg((IJExpression)initIndexVar));
        forBlock1.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)(this.lowerCaseFirstOneClassName + "{}={}"))).arg((IJExpression)initIndexVar).arg((IJExpression)itemIndexVar));
    }

    protected void processQueryForLimitListCondition() {
        JMethod method = this.prepareMethod("queryForLImitListCondition");
        JBlock methodBlk = method.body();
        JVar reqParamsJsonStrAndAssertJVar = method.param((AbstractJType)this.cmTest.ref("String"), "reqParamsJsonStrAndAssert");
        JVar paramsJsonJVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "paramsJson", (IJExpression)JExpr._this().invoke("parseStr2JsonArray").arg((IJExpression)reqParamsJsonStrAndAssertJVar).component(0));
        JVar conditionVar = methodBlk.decl((AbstractJType)this.cmTest.ref("String"), "condition", (IJExpression)JExpr._null());
        JVar conditionStrVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "conditionJson", (IJExpression)paramsJsonJVar.invoke("get").arg((IJExpression)JExpr.lit((String)"condition")));
        JBlock jNotNullBlock = methodBlk._if(conditionStrVar.ne((IJExpression)JExpr._null()))._then();
        jNotNullBlock.assign((IJAssignmentTarget)conditionVar, (IJExpression)conditionStrVar.invoke("asText"));
        JInvocation jInvocationTest = JExpr.invoke((IJExpression)this.fieldVar, (String)"queryForLImitListCondition").arg((IJExpression)conditionVar);
        JVar rowBoundsVar = methodBlk.decl((AbstractJType)this.cmTest.ref("org.apache.ibatis.session.RowBounds"), "rowBounds", (IJExpression)JExpr._null());
        JVar rowBoundsStrVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "rowBoundsJson", (IJExpression)paramsJsonJVar.invoke("get").arg((IJExpression)JExpr.lit((String)"rowBounds")));
        jNotNullBlock = methodBlk._if(rowBoundsStrVar.ne((IJExpression)JExpr._null()))._then();
        jNotNullBlock.assign((IJAssignmentTarget)rowBoundsVar, (IJExpression)this.cmTest.ref("com.fastjrun.utils.JacksonUtils").staticInvoke("readValue").arg((IJExpression)rowBoundsStrVar.invoke("toString")).arg(this.cmTest.ref("org.apache.ibatis.session.RowBounds").dotclass()));
        jInvocationTest.arg((IJExpression)rowBoundsVar);
        ObjectNode methodParamInJsonObject = JacksonUtils.createObjectNode();
        ObjectNode rowBoundsInJsonObject = JacksonUtils.createObjectNode();
        rowBoundsInJsonObject.put("offset", "int");
        rowBoundsInJsonObject.put("limit", "int");
        methodParamInJsonObject.put("rowBounds", rowBoundsInJsonObject.toString());
        methodParamInJsonObject.put("condition", "String");
        this.putIntoTestParam(methodParamInJsonObject, "queryForLImitListCondition");
        JVar listJVar = methodBlk.decl((AbstractJType)this.cmTest.ref("java.util.List").narrow(this.entityClass), "list", (IJExpression)jInvocationTest);
        jNotNullBlock = methodBlk._if(listJVar.ne((IJExpression)JExpr._null()))._then();
        JForLoop forLoop = jNotNullBlock._for();
        JVar initIndexVar = forLoop.init((AbstractJType)this.cmTest.INT, "index", (IJExpression)JExpr.lit((int)0));
        forLoop.test(initIndexVar.lt((IJExpression)listJVar.invoke("size")));
        forLoop.update(initIndexVar.incr());
        JBlock forBlock1 = forLoop.body();
        JVar itemIndexVar = forBlock1.decl((AbstractJType)this.entityClass, this.lowerCaseFirstOneClassName, (IJExpression)listJVar.invoke("get").arg((IJExpression)initIndexVar));
        forBlock1.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)(this.lowerCaseFirstOneClassName + "{}={}"))).arg((IJExpression)initIndexVar).arg((IJExpression)itemIndexVar));
    }

    protected void processInsertAll() {
        JMethod method = this.prepareMethod("insertAll");
        JBlock methodBlk = method.body();
        JVar reqParamsJsonStrAndAssertJVar = method.param((AbstractJType)this.cmTest.ref("String"), "reqParamsJsonStrAndAssert");
        JVar paramsJsonJVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "paramsJson", (IJExpression)JExpr._this().invoke("parseStr2JsonArray").arg((IJExpression)reqParamsJsonStrAndAssertJVar).component(0));
        JVar listVar = methodBlk.decl((AbstractJType)this.cmTest.ref("java.util.List").narrow(this.entityClass), this.lowerCaseFirstOneClassName + "s", (IJExpression)JExpr._null());
        JVar listStrVar = methodBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "listJson", (IJExpression)paramsJsonJVar.invoke("get").arg((IJExpression)JExpr.lit((String)(this.lowerCaseFirstOneClassName + "s"))));
        JBlock jNotNullBlock = methodBlk._if(listStrVar.ne((IJExpression)JExpr._null()))._then();
        jNotNullBlock.assign((IJAssignmentTarget)listVar, (IJExpression)this.cmTest.ref("com.fastjrun.utils.JacksonUtils").staticInvoke("readList").arg((IJExpression)listStrVar).arg(this.entityClass.dotclass()));
        JInvocation jInvocationTest = JExpr.invoke((IJExpression)this.fieldVar, (String)"insertAll").arg((IJExpression)listVar);
        JVar resJVar = methodBlk.decl((AbstractJType)this.cmTest.INT, "res", (IJExpression)jInvocationTest);
        methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"res={}")).arg((IJExpression)resJVar));
    }

    @Override
    public void generate() {
        this.lowerCaseFirstOneClassName = StringHelper.toLowerCaseFirstOne((String)this.fjTable.getClassName());
        this.daoTestParam = new Properties();
        this.processInsert();
        List<String> primaryKeyColumnNames = this.fjTable.getPrimaryKeyColumnNames();
        if (primaryKeyColumnNames != null && primaryKeyColumnNames.size() > 0) {
            this.processSelectByPK();
            this.processUpdateByPK();
            this.processDeleteByPK();
        }
        this.processTotalCount();
        this.processQueryForList();
        this.processQueryForLimitList();
        this.processTotalCountCondition();
        this.processSelectOneCondition();
        this.processQueryForListCondition();
        this.processQueryForLimitListCondition();
        this.processInsertAll();
    }
}

