/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.codeg.generator;

import com.fastjrun.codeg.common.CodeGConstants;
import com.fastjrun.codeg.common.CodeGException;
import com.fastjrun.codeg.common.PacketField;
import com.fastjrun.codeg.common.PacketObject;
import com.fastjrun.codeg.generator.common.BaseCMGenerator;
import com.fastjrun.helper.StringHelper;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JConditional;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JDocComment;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JForLoop;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.Map;

public class PacketGenerator
extends BaseCMGenerator {
    private PacketObject packetObject;
    private AbstractJClass packetObjectJClass;

    public PacketObject getPacketObject() {
        return this.packetObject;
    }

    public void setPacketObject(PacketObject packetObject) {
        this.packetObject = packetObject;
    }

    public AbstractJClass getPacketObjectJClass() {
        return this.packetObjectJClass;
    }

    public void setPacketObjectJClass(AbstractJClass packetObjectJClass) {
        this.packetObjectJClass = packetObjectJClass;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate() {
        if (!this.packetObject.is_new()) {
            this.packetObjectJClass = this.cm.ref(this.packetObject.get_class());
        } else {
            Map<String, PacketObject> lists;
            Map<String, PacketObject> objects;
            JDefinedClass dc;
            try {
                dc = this.cm._class(this.packageNamePrefix + this.packetObject.get_class());
            }
            catch (JClassAlreadyExistsException e) {
                String msg = this.packetObject.get_class() + " is already exists.";
                this.log.error(msg, (Throwable)e);
                throw new CodeGException("CG504", msg, (Exception)((Object)e));
            }
            this.log.debug(this.packetObject.get_class());
            dc._implements(this.cm.ref("java.io.Serializable"));
            if (this.packetObject.getParent() != null && !this.packetObject.getParent().equals("")) {
                dc._extends(this.cm.ref(this.packetObject.getParent()));
            }
            this.packetObjectJClass = dc;
            Long hashCode = 0L;
            hashCode = hashCode + (long)dc.getClass().getName().hashCode();
            Map<String, PacketField> fields = this.packetObject.getFields();
            JMethod toStringMethod = dc.method(1, (AbstractJType)this.cm.ref("String"), "toString");
            toStringMethod.annotate(this.cm.ref("Override"));
            JBlock toStringMethodBlk = toStringMethod.body();
            JVar toStringSBVar = toStringMethodBlk.decl((AbstractJType)this.cm.ref("StringBuilder"), "sb", (IJExpression)JExpr._new((AbstractJType)this.cm.ref("StringBuilder")));
            toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg(JExpr.lit((String)dc.name()).plus((IJExpression)JExpr.lit((String)" ["))));
            if (fields != null && fields.size() > 0) {
                int index = 0;
                toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"field [")));
                for (PacketField packetField : fields.values()) {
                    this.processField(index, packetField, dc, hashCode, toStringMethodBlk, toStringSBVar);
                    ++index;
                }
                toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"]")));
            }
            if ((objects = this.packetObject.getObjects()) != null && objects.size() > 0) {
                int index = 0;
                toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"object [")));
                for (String key : objects.keySet()) {
                    String char2;
                    hashCode = hashCode + (long)key.hashCode();
                    PacketObject object = objects.get(key);
                    AbstractJClass jObjectClass = this.processObjectORList(key, object, true, hashCode, dc, index, toStringMethodBlk, toStringSBVar);
                    hashCode = hashCode + (long)jObjectClass.hashCode();
                    String tterMethodName = key;
                    if (key.length() > 1 && !(char2 = String.valueOf(key.charAt(1))).equals(char2.toUpperCase())) {
                        tterMethodName = StringHelper.toUpperCaseFirstOne((String)key);
                    }
                    JFieldRef nameRef = JExpr.refthis((String)key);
                    dc.field(4, (AbstractJType)jObjectClass, key);
                    JMethod setMethod = dc.method(1, (AbstractJType)this.cm.VOID, "set" + tterMethodName);
                    JMethod getMethod = dc.method(1, (AbstractJType)jObjectClass, "get" + tterMethodName);
                    JVar jvar = setMethod.param((AbstractJType)jObjectClass, key);
                    JBlock setMethodBlk = setMethod.body();
                    hashCode = hashCode + (long)setMethod.name().hashCode();
                    setMethodBlk.assign((IJAssignmentTarget)nameRef, (IJExpression)jvar);
                    hashCode = hashCode + (long)getMethod.name().hashCode();
                    JBlock getMethodBlk = getMethod.body();
                    getMethodBlk._return((IJExpression)nameRef);
                    if (index > 0) {
                        toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)",")));
                    }
                    toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)key)));
                    toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"=")));
                    JConditional jConditional = toStringMethodBlk._if(nameRef.ne((IJExpression)JExpr._null()));
                    jConditional._else().add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"null")));
                    JBlock jThenBlock = jConditional._then();
                    jThenBlock.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)nameRef));
                }
                toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"]")));
            }
            if ((lists = this.packetObject.getLists()) != null && lists.size() > 0) {
                boolean bl = false;
                toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"list [")));
                for (String key : lists.keySet()) {
                    String char2;
                    void var9_17;
                    hashCode = hashCode + (long)key.hashCode();
                    PacketObject list = lists.get(key);
                    AbstractJClass jListObject = this.processObjectORList(key, list, false, hashCode, dc, (int)var9_17, toStringMethodBlk, toStringSBVar);
                    hashCode = hashCode + (long)jListObject.hashCode();
                    String tterMethodName = key;
                    if (key.length() > 1 && !(char2 = String.valueOf(key.charAt(1))).equals(char2.toUpperCase())) {
                        tterMethodName = StringHelper.toUpperCaseFirstOne((String)key);
                    }
                    JFieldRef nameRef = JExpr.refthis((String)key);
                    dc.field(4, (AbstractJType)this.cm.ref("java.util.List").narrow(jListObject), key);
                    JMethod setMethod = dc.method(1, (AbstractJType)this.cm.VOID, "set" + tterMethodName);
                    JMethod getMethod = dc.method(1, (AbstractJType)this.cm.ref("java.util.List").narrow(jListObject), "get" + tterMethodName);
                    JVar jvar = setMethod.param((AbstractJType)this.cm.ref("java.util.List").narrow(jListObject), key);
                    ++var9_17;
                    JBlock setMethodBlk = setMethod.body();
                    hashCode = hashCode + (long)setMethod.name().hashCode();
                    setMethodBlk.assign((IJAssignmentTarget)nameRef, (IJExpression)jvar);
                    hashCode = hashCode + (long)getMethod.name().hashCode();
                    JBlock getMethodBlk = getMethod.body();
                    getMethodBlk._return((IJExpression)nameRef);
                    if (var9_17 > 0) {
                        toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)",")));
                    }
                    toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)key)));
                    toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"=")));
                    JConditional jConditional = toStringMethodBlk._if(nameRef.ne((IJExpression)JExpr._null()));
                    jConditional._else().add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"null")));
                    JBlock jThenBlock = jConditional._then();
                    JForLoop forLoop = jThenBlock._for();
                    JVar iVar = forLoop.init((AbstractJType)this.cm.INT, "i", (IJExpression)JExpr.lit((int)0));
                    forLoop.test(iVar.lt((IJExpression)nameRef.invoke("size")));
                    forLoop.update(iVar.incr());
                    JBlock forBody = forLoop.body();
                    String poDcName = StringHelper.toLowerCaseFirstOne((String)jListObject.name());
                    JVar poDcObjectVar = forBody.decl((AbstractJType)jListObject, poDcName, (IJExpression)nameRef.invoke("get").arg((IJExpression)iVar));
                    forBody._if(iVar.eq((IJExpression)JExpr.lit((int)0)))._then().add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"[")));
                    forBody._if(iVar.gt((IJExpression)JExpr.lit((int)0)))._then().add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)",")));
                    forBody.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"list.")));
                    forBody.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)iVar));
                    forBody.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"=")));
                    forBody.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)poDcObjectVar));
                    jThenBlock.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"]")));
                }
                toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"]")));
            }
            dc.field(28, (AbstractJType)this.cm.LONG, "serialVersionUID", (IJExpression)JExpr.lit((long)hashCode));
            toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"]")));
            toStringMethodBlk._return((IJExpression)toStringSBVar.invoke("toString"));
            this.addClassDeclaration(dc);
        }
    }

    public void processField(int index, PacketField field, JDefinedClass dc, Long hashCode, JBlock toStringMethodBlk, JVar toStringSBVar) {
        String char2;
        AbstractJClass jType;
        String fieldName = field.getName();
        String dataType = field.getDatatype();
        hashCode = hashCode + (long)fieldName.hashCode();
        if (dataType.endsWith(":List")) {
            String primitiveType = dataType.split(":")[0];
            jType = this.cm.ref("java.util.List").narrow(this.cm.ref(primitiveType));
        } else {
            jType = this.cm.ref(dataType);
        }
        JFieldVar fieldVar = dc.field(4, (AbstractJType)jType, fieldName);
        if (this.getMockModel() == CodeGConstants.MockModel.MockModel_Swagger) {
            fieldVar.annotate(this.cm.ref("io.swagger.annotations.ApiModelProperty")).param("value", field.getRemark()).param("required", (IJExpression)JExpr.lit((!field.isCanBeNull() ? 1 : 0) != 0));
        }
        JDocComment jdoc = fieldVar.javadoc();
        jdoc.add((Object)field.getRemark());
        JFieldRef nameRef = JExpr.refthis((String)fieldName);
        if (index > 0) {
            toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)",")));
        }
        toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)fieldName)));
        toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)JExpr.lit((String)"=")));
        toStringMethodBlk.add((IJStatement)toStringSBVar.invoke("append").arg((IJExpression)nameRef));
        String tterMethodName = fieldName;
        if (fieldName.length() > 1 && !(char2 = String.valueOf(fieldName.charAt(1))).equals(char2.toUpperCase())) {
            tterMethodName = StringHelper.toUpperCaseFirstOne((String)fieldName);
        }
        JMethod getMethod = dc.method(1, (AbstractJType)jType, "get" + tterMethodName);
        hashCode = hashCode + (long)getMethod.name().hashCode();
        JBlock getMethodBlk = getMethod.body();
        getMethodBlk._return((IJExpression)nameRef);
        JMethod setMethod = dc.method(1, (AbstractJType)this.cm.VOID, "set" + tterMethodName);
        JVar jvar = setMethod.param((AbstractJType)jType, fieldName);
        hashCode = hashCode + (long)setMethod.name().hashCode();
        JBlock setMethodBlk = setMethod.body();
        if (dc.getPackage().name().endsWith("res") && jvar.type().name().equals("String")) {
            JConditional ifBlock = setMethodBlk._if(jvar.eq((IJExpression)JExpr._null()));
            ifBlock._then().assign((IJAssignmentTarget)nameRef, (IJExpression)JExpr.lit((String)""));
            ifBlock._else().assign((IJAssignmentTarget)nameRef, (IJExpression)jvar);
        } else {
            setMethodBlk.assign((IJAssignmentTarget)nameRef, (IJExpression)jvar);
        }
    }

    public AbstractJClass processObjectORList(String key, PacketObject po, boolean isObject, Long hashCode, JDefinedClass dc, int index, JBlock toStringMethodBlk, JVar toStringSBVar) {
        if (po.is_new()) {
            return this.cm.ref(this.packageNamePrefix + po.get_class());
        }
        return this.cm.ref(po.get_class());
    }
}

