/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.codeg.generator;

import com.fastjrun.codeg.common.CodeGConstants;
import com.fastjrun.codeg.common.CodeGException;
import com.fastjrun.codeg.common.CommonMethod;
import com.fastjrun.codeg.common.CommonService;
import com.fastjrun.codeg.generator.common.BaseCMGenerator;
import com.fastjrun.codeg.generator.method.ServiceMethodGenerator;
import com.fastjrun.helper.StringHelper;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.EClassType;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JFieldVar;
import java.util.HashMap;
import java.util.Map;

public class ServiceGenerator
extends BaseCMGenerator {
    static String SERVICETEST_SUFFIX = "Test";
    protected CommonService commonService;
    protected JDefinedClass serviceClass;
    protected JDefinedClass serviceTestClass;
    protected JDefinedClass serviceMockClass;
    private boolean supportTest = false;
    private Map<CommonMethod, ServiceMethodGenerator> serviceMethodGeneratorMap;

    public Map<CommonMethod, ServiceMethodGenerator> getServiceMethodGeneratorMap() {
        return this.serviceMethodGeneratorMap;
    }

    public JDefinedClass getServiceMockClass() {
        return this.serviceMockClass;
    }

    public void setServiceMockClass(JDefinedClass serviceMockClass) {
        this.serviceMockClass = serviceMockClass;
    }

    public CommonService getCommonService() {
        return this.commonService;
    }

    public void setCommonService(CommonService commonService) {
        this.commonService = commonService;
    }

    public JDefinedClass getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(JDefinedClass serviceClass) {
        this.serviceClass = serviceClass;
    }

    public boolean isSupportTest() {
        return this.supportTest;
    }

    public void setSupportTest(boolean supportTest) {
        this.supportTest = supportTest;
    }

    public JDefinedClass getServiceTestClass() {
        return this.serviceTestClass;
    }

    public void setServiceTestClass(JDefinedClass serviceTestClass) {
        this.serviceTestClass = serviceTestClass;
    }

    protected void processService() {
        try {
            this.serviceClass = this.cm._class(this.packageNamePrefix + SERVICE_PACKAGE_NAME + this.commonService.get_class(), EClassType.INTERFACE);
        }
        catch (JClassAlreadyExistsException e) {
            String msg = this.commonService.get_class() + " is already exists.";
            this.log.error(msg, (Throwable)e);
            throw new CodeGException("CG504", msg, (Exception)((Object)e));
        }
        this.addClassDeclaration(this.serviceClass);
    }

    protected JFieldVar processServiceTest() {
        try {
            this.serviceTestClass = this.cmTest._class(this.packageNamePrefix + SERVICE_PACKAGE_NAME + this.commonService.get_class() + SERVICETEST_SUFFIX);
        }
        catch (JClassAlreadyExistsException e) {
            String msg = this.commonService.get_class() + SERVICETEST_SUFFIX + " is already exists.";
            this.log.error(msg, (Throwable)e);
            throw new CodeGException("CG504", msg, (Exception)((Object)e));
        }
        this.serviceTestClass._extends(this.cmTest.ref("com.fastjrun.test.AbstractAdVancedTestNGSpringContextTest"));
        this.addClassDeclaration(this.serviceTestClass);
        String lowerCaseFirstOneClassName = StringHelper.toLowerCaseFirstOne((String)this.serviceClass.name());
        JFieldVar fieldVar = this.serviceTestClass.field(4, (AbstractJType)this.serviceClass, lowerCaseFirstOneClassName);
        fieldVar.annotate(this.cmTest.ref("org.springframework.beans.factory.annotation.Autowired"));
        return fieldVar;
    }

    protected void processServiceMock() {
        try {
            this.serviceMockClass = this.cm._class(MOCK_PACKAGE_NAME + this.commonService.get_class() + "Mock");
            this.serviceMockClass._implements((AbstractJClass)this.serviceClass);
            this.serviceMockClass.annotate(this.cm.ref("org.springframework.stereotype.Service")).param("value", this.commonService.getName());
        }
        catch (JClassAlreadyExistsException e) {
            String msg = this.commonService.get_class() + " is already exists.";
            this.log.error(msg, (Throwable)e);
            throw new CodeGException("CG504", msg, (Exception)((Object)e));
        }
        this.addClassDeclaration(this.serviceMockClass);
    }

    @Override
    public void generate() {
        JFieldVar fieldVar = null;
        if (!this.isApi()) {
            this.processService();
            if (this.supportTest) {
                fieldVar = this.processServiceTest();
            }
            if (!this.isClient() && this.mockModel != CodeGConstants.MockModel.MockModel_Common) {
                this.processServiceMock();
            }
        }
        this.serviceMethodGeneratorMap = new HashMap<CommonMethod, ServiceMethodGenerator>();
        for (CommonMethod commonMethod : this.commonService.getMethods()) {
            ServiceMethodGenerator serviceMethodGenerator = new ServiceMethodGenerator();
            serviceMethodGenerator.setPackageNamePrefix(this.packageNamePrefix);
            serviceMethodGenerator.setMockModel(this.mockModel);
            serviceMethodGenerator.setAuthor(this.author);
            serviceMethodGenerator.setCompany(this.company);
            serviceMethodGenerator.setApi(this.isApi());
            serviceMethodGenerator.setClient(this.isClient());
            serviceMethodGenerator.setServiceGenerator(this);
            serviceMethodGenerator.setCommonMethod(commonMethod);
            serviceMethodGenerator.setCm(this.cm);
            serviceMethodGenerator.setCmTest(this.cmTest);
            serviceMethodGenerator.setFieldVar(fieldVar);
            serviceMethodGenerator.generate();
            this.serviceMethodGeneratorMap.put(commonMethod, serviceMethodGenerator);
        }
    }
}

