/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.codeg.generator.common;

import com.fastjrun.codeg.common.CodeGConstants;
import com.fastjrun.codeg.common.CodeGException;
import com.fastjrun.codeg.common.CommonController;
import com.fastjrun.codeg.common.CommonMethod;
import com.fastjrun.codeg.generator.ServiceGenerator;
import com.fastjrun.codeg.generator.common.BaseCMGenerator;
import com.fastjrun.codeg.generator.method.BaseControllerMethodGenerator;
import com.fastjrun.codeg.generator.method.ServiceMethodGenerator;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JNarrowedClass;
import java.util.Properties;

public abstract class BaseControllerGenerator
extends BaseCMGenerator {
    protected String webPackageName;
    protected CommonController commonController;
    protected String clientName;
    protected JDefinedClass clientClass;
    protected JDefinedClass clientTestClass;
    protected Properties clientTestParam;
    protected JDefinedClass controlllerClass;
    protected String controllerPath;
    protected ServiceGenerator serviceGenerator;

    public String getWebPackageName() {
        return this.webPackageName;
    }

    public void setWebPackageName(String webPackageName) {
        this.webPackageName = webPackageName;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getControllerPath() {
        return this.controllerPath;
    }

    public void setControllerPath(String controllerPath) {
        this.controllerPath = controllerPath;
    }

    public ServiceGenerator getServiceGenerator() {
        return this.serviceGenerator;
    }

    public void setServiceGenerator(ServiceGenerator serviceGenerator) {
        this.serviceGenerator = serviceGenerator;
    }

    public JDefinedClass getClientClass() {
        return this.clientClass;
    }

    public JDefinedClass getClientTestClass() {
        return this.clientTestClass;
    }

    public void setClientTestClass(JDefinedClass clientTestClass) {
        this.clientTestClass = clientTestClass;
    }

    public Properties getClientTestParam() {
        return this.clientTestParam;
    }

    public CommonController getCommonController() {
        return this.commonController;
    }

    public void setCommonController(CommonController commonController) {
        this.commonController = commonController;
    }

    public JDefinedClass getControlllerClass() {
        return this.controlllerClass;
    }

    public void setControlllerClass(JDefinedClass controlllerClass) {
        this.controlllerClass = controlllerClass;
    }

    public abstract BaseControllerMethodGenerator prepareBaseControllerMethodGenerator(ServiceMethodGenerator var1);

    protected void processController() {
        CodeGConstants.ControllerType controllerType = this.commonController.getControllerType();
        String controllerPackageName = this.packageNamePrefix + this.webPackageName;
        if (this.getMockModel() != CodeGConstants.MockModel.MockModel_Common) {
            controllerPackageName = MOCK_PACKAGE_NAME + "web.controller.";
        }
        String controllerName = this.commonController.getName() + controllerType.providerSuffix;
        try {
            this.controlllerClass = this.cm._class(controllerPackageName + controllerName);
            if (controllerType.providerParentName != null && !controllerType.providerParentName.equals("")) {
                this.controlllerClass._extends(this.cm.ref(controllerType.providerParentName));
            }
        }
        catch (JClassAlreadyExistsException e) {
            String msg = this.commonController.getName() + " is already exists.";
            this.log.error(msg, (Throwable)e);
            throw new CodeGException("CG504", msg, (Exception)((Object)e));
        }
        this.controlllerClass.annotate(this.cm.ref("org.springframework.web.bind.annotation.RestController"));
        this.controlllerClass.annotate(this.cm.ref("org.springframework.web.bind.annotation.RequestMapping")).param("value", this.controllerPath);
        if (this.getMockModel() == CodeGConstants.MockModel.MockModel_Swagger) {
            this.controlllerClass.annotate(this.cm.ref("io.swagger.annotations.Api")).param("value", this.commonController.getRemark()).param("tags", this.commonController.getTags());
        }
        this.addClassDeclaration(this.controlllerClass);
        String serviceName = this.commonController.getServiceName();
        JFieldVar fieldVar = this.controlllerClass.field(4, (AbstractJType)this.serviceGenerator.getServiceClass(), serviceName);
        fieldVar.annotate(this.cm.ref("org.springframework.beans.factory.annotation.Autowired"));
        fieldVar.annotate(this.cm.ref("org.springframework.beans.factory.annotation.Qualifier")).param("value", this.commonController.getServiceRef());
    }

    protected void processClientTest() {
        try {
            this.clientTestClass = this.cmTest._class(this.getPackageNamePrefix() + "client." + this.clientName + "Test");
        }
        catch (JClassAlreadyExistsException e) {
            String msg = this.commonController.getName() + "Test is already exists.";
            this.log.error(msg, (Throwable)e);
            throw new CodeGException("CG504", msg, (Exception)((Object)e));
        }
        this.clientTestClass._extends((AbstractJClass)this.cmTest.ref("com.fastjrun.client.BaseApplicationClientTest").narrow((AbstractJClass)this.clientClass));
        this.addClassDeclaration(this.clientTestClass);
        JMethod clientTestPrepareApplicationClientMethod = this.clientTestClass.method(1, (AbstractJType)this.cmTest.VOID, "prepareApplicationClient");
        clientTestPrepareApplicationClientMethod.annotate(this.cmTest.ref("Override"));
        clientTestPrepareApplicationClientMethod.annotate(this.cmTest.ref("org.testng.annotations.BeforeClass"));
        JBlock jBlock = clientTestPrepareApplicationClientMethod.body();
        jBlock.assign((IJAssignmentTarget)JExpr.ref((String)"baseApplicationClient"), (IJExpression)JExpr._new((AbstractJType)this.clientClass));
        jBlock.add((IJStatement)JExpr.ref((String)"baseApplicationClient").invoke("initSDKConfig"));
    }

    protected void processClient() {
        CodeGConstants.ControllerType controllerType = this.commonController.getControllerType();
        this.clientName = this.commonController.getClientName();
        int lastDotIndex = this.clientName.lastIndexOf(".");
        if (lastDotIndex > 0) {
            this.clientName = this.clientName.substring(lastDotIndex + 1, this.clientName.length());
        }
        this.clientName = this.clientName + controllerType.clientSuffix;
        try {
            this.clientClass = this.cm._class(this.getPackageNamePrefix() + "client." + this.clientName);
        }
        catch (JClassAlreadyExistsException e) {
            String msg = this.commonController.getName() + " is already exists.";
            this.log.error(msg, (Throwable)e);
            throw new CodeGException("CG504", msg, (Exception)((Object)e));
        }
        AbstractJClass baseClientClass = this.cm.ref(controllerType.baseClient);
        JNarrowedClass jParentClass = this.cm.ref("com.fastjrun.client.BaseApplicationClient").narrow(baseClientClass);
        this.addClassDeclaration(this.clientClass);
        this.clientClass._extends((AbstractJClass)jParentClass);
        this.clientClass._implements((AbstractJClass)this.serviceGenerator.getServiceClass());
        JMethod clientInitMethod = this.clientClass.method(1, (AbstractJType)this.cm.VOID, "initSDKConfig");
        clientInitMethod.annotate(this.cm.ref("Override"));
        JBlock jInitBlock = clientInitMethod.body();
        jInitBlock.assign((IJAssignmentTarget)JExpr.ref((String)"baseClient"), (IJExpression)JExpr._new((AbstractJType)baseClientClass));
        jInitBlock.invoke((IJExpression)JExpr.ref((String)"baseClient"), "initSDKConfig");
    }

    protected void genreateControllerPath() {
        this.controllerPath = this.commonController.getPath();
        String version = this.commonController.getVersion();
        if (version != null && !version.equals("")) {
            this.controllerPath = this.controllerPath + "/" + version;
        }
    }

    protected void generatorControllerMethod() {
        for (CommonMethod commonMethod : this.commonController.getService().getMethods()) {
            ServiceMethodGenerator serviceMethodGenerator = this.serviceGenerator.getServiceMethodGeneratorMap().get(commonMethod);
            BaseControllerMethodGenerator baseControllerMethodGenerator = this.prepareBaseControllerMethodGenerator(serviceMethodGenerator);
            baseControllerMethodGenerator.setApi(this.isApi());
            baseControllerMethodGenerator.setClient(this.isClient());
            baseControllerMethodGenerator.setCm(this.cm);
            baseControllerMethodGenerator.setCmTest(this.cmTest);
            baseControllerMethodGenerator.generate();
        }
    }
}

