/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.codeg.generator.method;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fastjrun.codeg.common.PacketField;
import com.fastjrun.codeg.common.PacketObject;
import com.fastjrun.codeg.generator.common.BaseCMGenerator;
import com.fastjrun.utils.JacksonUtils;
import com.helger.jcodemodel.AbstractJClass;
import java.util.Map;

public abstract class AbstractMethodGenerator
extends BaseCMGenerator {
    protected ObjectNode methodParamInJsonObject;

    public void setMethodParamInJsonObject(ObjectNode methodParamInJsonObject) {
        this.methodParamInJsonObject = methodParamInJsonObject;
    }

    protected ObjectNode composeRequestBody(PacketObject requestBody) {
        Map<String, PacketObject> roList;
        ObjectNode jsonRequestBody = this.composeRequestBodyField(requestBody);
        Map<String, PacketObject> robjects = requestBody.getObjects();
        if (robjects != null && robjects.size() > 0) {
            for (String reName : robjects.keySet()) {
                PacketObject ro = robjects.get(reName);
                ObjectNode jsonRe = this.composeRequestBody(ro);
                jsonRequestBody.set(reName, (JsonNode)jsonRe);
            }
        }
        if ((roList = requestBody.getLists()) != null && roList.size() > 0) {
            for (String listName : roList.keySet()) {
                PacketObject ro = roList.get(listName);
                ObjectNode jsonRe = this.composeRequestBody(ro);
                ArrayNode jsonAy = JacksonUtils.createArrayNode();
                jsonAy.add((JsonNode)jsonRe);
                jsonRequestBody.set(listName, (JsonNode)jsonAy);
            }
        }
        return jsonRequestBody;
    }

    protected ObjectNode composeRequestBodyField(PacketObject requestBody) {
        ObjectNode jsonRequestBody = JacksonUtils.createObjectNode();
        Map<String, PacketField> fields = requestBody.getFields();
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                AbstractJClass jType;
                PacketField restField = fields.get(fieldName);
                String dataType = restField.getDatatype();
                if (dataType.endsWith(":List")) {
                    AbstractJClass primitiveType = this.cmTest.ref(dataType.split(":")[0]);
                    jType = this.cmTest.ref("java.util.List").narrow(primitiveType);
                } else {
                    jType = this.cmTest.ref(dataType);
                }
                jsonRequestBody.put(fieldName, jType.name());
            }
        }
        return jsonRequestBody;
    }
}

