/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.codeg.generator.method;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fastjrun.codeg.common.CodeGConstants;
import com.fastjrun.codeg.common.CommonController;
import com.fastjrun.codeg.common.PacketField;
import com.fastjrun.codeg.generator.common.BaseControllerGenerator;
import com.fastjrun.codeg.generator.method.AbstractMethodGenerator;
import com.fastjrun.codeg.generator.method.MethodGeneratorHelper;
import com.fastjrun.codeg.generator.method.ServiceMethodGenerator;
import com.fastjrun.codeg.processer.ExchangeProcessor;
import com.fastjrun.helper.StringHelper;
import com.fastjrun.utils.JacksonUtils;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAnnotationArrayMember;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCatchBlock;
import com.helger.jcodemodel.JConditional;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JForLoop;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JTryBlock;
import com.helger.jcodemodel.JVar;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class BaseControllerMethodGenerator
extends AbstractMethodGenerator {
    protected JMethod jClientMethod;
    protected JMethod jClientTestMethod;
    protected JMethod jcontrollerMethod;
    protected ExchangeProcessor exchangeProcessor;
    protected ServiceMethodGenerator serviceMethodGenerator;
    protected BaseControllerGenerator baseControllerGenerator;

    public void setServiceMethodGenerator(ServiceMethodGenerator serviceMethodGenerator) {
        this.serviceMethodGenerator = serviceMethodGenerator;
    }

    public void setBaseControllerGenerator(BaseControllerGenerator baseControllerGenerator) {
        this.baseControllerGenerator = baseControllerGenerator;
    }

    public void setExchangeProcessor(ExchangeProcessor exchangeProcessor) {
        this.exchangeProcessor = exchangeProcessor;
    }

    public JMethod getjClientMethod() {
        return this.jClientMethod;
    }

    public void setjClientMethod(JMethod jClientMethod) {
        this.jClientMethod = jClientMethod;
    }

    public JMethod getjClientTestMethod() {
        return this.jClientTestMethod;
    }

    public void setjClientTestMethod(JMethod jClientTestMethod) {
        this.jClientTestMethod = jClientTestMethod;
    }

    public JMethod getJcontrollerMethod() {
        return this.jcontrollerMethod;
    }

    public void setJcontrollerMethod(JMethod jcontrollerMethod) {
        this.jcontrollerMethod = jcontrollerMethod;
    }

    public void processClientTestMethod(JDefinedClass clientTestClass) {
        List<PacketField> cookies;
        List<PacketField> parameters;
        List<PacketField> pathVariables;
        JMethod clientTestMethod = clientTestClass.method(1, (AbstractJType)this.cmTest.VOID, "test" + StringHelper.toUpperCaseFirstOne((String)this.serviceMethodGenerator.methodName));
        JAnnotationUse methodTestAnnotationTest = clientTestMethod.annotate(this.cmTest.ref("org.testng.annotations.Test"));
        JBlock methodTestBlk = clientTestMethod.body();
        methodTestAnnotationTest.param("dataProvider", "loadParam");
        JVar reqParamsJsonStrAndAssertJVar = clientTestMethod.param((AbstractJType)this.cmTest.ref("String"), "reqParamsJsonStrAndAssert");
        JVar jsonNodes = methodTestBlk.decl((AbstractJType)this.cmTest.ref("com.fasterxml.jackson.databind.JsonNode").array(), "jsonNodes", (IJExpression)JExpr.invoke((String)"parseStr2JsonArray").arg((IJExpression)reqParamsJsonStrAndAssertJVar));
        JVar reqParamsJsonJVar = methodTestBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "reqParamsJson", (IJExpression)jsonNodes.component(0));
        JVar assertJsonJVar = methodTestBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "assertJson", (IJExpression)jsonNodes.component(1));
        JInvocation jInvocationTest = JExpr.invoke((IJExpression)JExpr.ref((String)"baseApplicationClient"), (String)this.serviceMethodGenerator.methodName);
        AbstractJClass exceptionClass = this.cmTest.ref("com.fastjrun.common.ClientException");
        List<PacketField> headVariables = this.serviceMethodGenerator.getCommonMethod().getHeadVariables();
        if (headVariables != null && headVariables.size() > 0) {
            for (int index = 0; index < headVariables.size(); ++index) {
                PacketField headVariable = headVariables.get(index);
                jInvocationTest.arg((IJExpression)JExpr.ref((String)headVariable.getNameAlias()));
                MethodGeneratorHelper.processMethodCommonVariables(this.cmTest, methodTestBlk, reqParamsJsonJVar, headVariable);
            }
        }
        if ((pathVariables = this.serviceMethodGenerator.getCommonMethod().getPathVariables()) != null && pathVariables.size() > 0) {
            for (int index = 0; index < pathVariables.size(); ++index) {
                PacketField pathVariable = pathVariables.get(index);
                jInvocationTest.arg((IJExpression)JExpr.ref((String)pathVariable.getName()));
                MethodGeneratorHelper.processMethodCommonVariables(this.cmTest, methodTestBlk, reqParamsJsonJVar, pathVariable);
            }
        }
        if ((parameters = this.serviceMethodGenerator.getCommonMethod().getParameters()) != null && parameters.size() > 0) {
            for (int index = 0; index < parameters.size(); ++index) {
                PacketField parameter = parameters.get(index);
                jInvocationTest.arg((IJExpression)JExpr.ref((String)parameter.getName()));
                MethodGeneratorHelper.processMethodCommonVariables(this.cmTest, methodTestBlk, reqParamsJsonJVar, parameter);
            }
        }
        if ((cookies = this.serviceMethodGenerator.getCommonMethod().getCookieVariables()) != null && cookies.size() > 0) {
            for (int index = 0; index < cookies.size(); ++index) {
                PacketField cookie = cookies.get(index);
                jInvocationTest.arg((IJExpression)JExpr.ref((String)cookie.getName()));
                MethodGeneratorHelper.processMethodCommonVariables(this.cmTest, methodTestBlk, reqParamsJsonJVar, cookie);
            }
        }
        if (this.serviceMethodGenerator.getRequestBodyClass() != null) {
            JVar requestBodyVar = methodTestBlk.decl(this.serviceMethodGenerator.getRequestBodyClass(), "requestBody", (IJExpression)JExpr._null());
            JVar requestBodyStrVar = methodTestBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "reqJsonRequestBody", (IJExpression)reqParamsJsonJVar.invoke("get").arg((IJExpression)JExpr.lit((String)"requestBody")));
            JBlock jNotNullBlock = methodTestBlk._if(requestBodyStrVar.ne((IJExpression)JExpr._null()))._then();
            jNotNullBlock.assign((IJAssignmentTarget)requestBodyVar, (IJExpression)this.cmTest.ref("com.fastjrun.utils.JacksonUtils").staticInvoke("readValue").arg((IJExpression)requestBodyStrVar.invoke("toString")).arg(((AbstractJClass)this.serviceMethodGenerator.getRequestBodyClass()).dotclass()));
            jInvocationTest.arg((IJExpression)requestBodyVar);
        }
        if (this.serviceMethodGenerator.getResponseBodyClass() != this.cm.VOID) {
            JVar responseBodyVar = methodTestBlk.decl(this.serviceMethodGenerator.getResponseBodyClass(), "responseBody", (IJExpression)JExpr._null());
            JConditional jConditional1 = methodTestBlk._if(assertJsonJVar.ne((IJExpression)JExpr._null()));
            JBlock jConditional1Block = jConditional1._then();
            JVar codeNodeJVar = jConditional1Block.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "codeNode", (IJExpression)assertJsonJVar.invoke("get").arg("code"));
            JConditional jConditional2 = jConditional1Block._if(codeNodeJVar.ne((IJExpression)JExpr._null()));
            JBlock jConditional2ThenBlock = jConditional2._then();
            JTryBlock jTry = jConditional2ThenBlock._try();
            jTry.body().assign((IJAssignmentTarget)responseBodyVar, (IJExpression)jInvocationTest);
            JCatchBlock jCatchBlock = jTry._catch(exceptionClass);
            JVar jExceptionVar = jCatchBlock.param("e");
            JBlock jCatchBlockBody = jCatchBlock.body();
            jCatchBlockBody.add((IJStatement)this.cmTest.ref("org.testng.Assert").staticInvoke("assertEquals").arg((IJExpression)jExceptionVar.invoke("getCode")).arg((IJExpression)codeNodeJVar.invoke("asText")).arg(JExpr.lit((String)"\u8fd4\u56de\u6d88\u606f\u7801\u4e0d\u662f\u6307\u5b9a\u6d88\u606f\u7801\uff1a").plus((IJExpression)codeNodeJVar.invoke("asText"))));
            jConditional2._else().assign((IJAssignmentTarget)responseBodyVar, (IJExpression)jInvocationTest);
            jConditional1._else().assign((IJAssignmentTarget)responseBodyVar, (IJExpression)jInvocationTest);
            methodTestBlk.add((IJStatement)JExpr.refthis((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"response={}")).arg((IJExpression)this.cmTest.ref("com.fastjrun.utils.JacksonUtils").staticInvoke("toJSon").arg((IJExpression)responseBodyVar)));
            JBlock ifBlock1 = methodTestBlk._if(responseBodyVar.ne((IJExpression)JExpr._null()))._then();
            if (this.serviceMethodGenerator.getCommonMethod().isResponseIsArray()) {
                JForLoop forLoop = ifBlock1._for();
                JVar initIndexVar = forLoop.init((AbstractJType)this.cmTest.INT, "index", (IJExpression)JExpr.lit((int)0));
                forLoop.test(initIndexVar.lt((IJExpression)responseBodyVar.invoke("size")));
                forLoop.update(initIndexVar.incr());
                JBlock forBlock1 = forLoop.body();
                JVar responseBodyIndexVar = forBlock1.decl((AbstractJType)this.serviceMethodGenerator.getElementClass(), "item" + this.serviceMethodGenerator.getElementClass().name(), (IJExpression)responseBodyVar.invoke("get").arg((IJExpression)initIndexVar));
                MethodGeneratorHelper.logResponseBody(this.cmTest, this.log, this.packageNamePrefix, 1, this.serviceMethodGenerator.getCommonMethod().getResponse(), responseBodyIndexVar, forBlock1);
            } else {
                MethodGeneratorHelper.logResponseBody(this.cmTest, this.log, this.packageNamePrefix, 1, this.serviceMethodGenerator.getCommonMethod().getResponse(), responseBodyVar, ifBlock1);
            }
            ifBlock1.add((IJStatement)JExpr._this().invoke("processAssertion").arg((IJExpression)assertJsonJVar).arg((IJExpression)responseBodyVar).arg(JExpr.dotClass((AbstractJType)this.serviceMethodGenerator.getResponseBodyClass())));
        } else {
            JConditional jConditional1 = methodTestBlk._if(assertJsonJVar.ne((IJExpression)JExpr._null()));
            JBlock jConditional1Block = jConditional1._then();
            JVar codeNodeJVar = jConditional1Block.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "codeNode", (IJExpression)assertJsonJVar.invoke("get").arg("code"));
            JConditional jConditional2 = jConditional1Block._if(codeNodeJVar.ne((IJExpression)JExpr._null()));
            JBlock jConditional2ThenBlock = jConditional2._then();
            JTryBlock jTry = jConditional2ThenBlock._try();
            jTry.body().add((IJStatement)jInvocationTest);
            JCatchBlock jCatchBlock = jTry._catch(exceptionClass);
            JVar jExceptionVar = jCatchBlock.param("e");
            JBlock jCatchBlockBody = jCatchBlock.body();
            jCatchBlockBody.add((IJStatement)this.cmTest.ref("org.testng.Assert").staticInvoke("assertEquals").arg((IJExpression)jExceptionVar.invoke("getCode")).arg((IJExpression)codeNodeJVar.invoke("asText")).arg(JExpr.lit((String)"\u8fd4\u56de\u6d88\u606f\u7801\u4e0d\u662f\u6307\u5b9a\u6d88\u606f\u7801\uff1a").plus((IJExpression)codeNodeJVar.invoke("asText"))));
            jConditional2._else().add((IJStatement)jInvocationTest);
            jConditional1._else().add((IJStatement)jInvocationTest);
        }
    }

    public void processClientTestPraram() {
        List<PacketField> cookies;
        List<PacketField> parameters;
        List<PacketField> pathVariables;
        this.methodParamInJsonObject = JacksonUtils.createObjectNode();
        List<PacketField> headVariables = this.serviceMethodGenerator.getCommonMethod().getHeadVariables();
        if (headVariables != null && headVariables.size() > 0) {
            for (int index = 0; index < headVariables.size(); ++index) {
                PacketField headVariable = headVariables.get(index);
                this.methodParamInJsonObject.put(headVariable.getNameAlias(), headVariable.getDatatype());
            }
        }
        if ((pathVariables = this.serviceMethodGenerator.getCommonMethod().getPathVariables()) != null && pathVariables.size() > 0) {
            for (int index = 0; index < pathVariables.size(); ++index) {
                PacketField pathVariable = pathVariables.get(index);
                this.methodParamInJsonObject.put(pathVariable.getName(), pathVariable.getDatatype());
            }
        }
        if ((parameters = this.serviceMethodGenerator.getCommonMethod().getParameters()) != null && parameters.size() > 0) {
            for (int index = 0; index < parameters.size(); ++index) {
                PacketField parameter = parameters.get(index);
                this.methodParamInJsonObject.put(parameter.getName(), parameter.getDatatype());
            }
        }
        if ((cookies = this.serviceMethodGenerator.getCommonMethod().getCookieVariables()) != null && cookies.size() > 0) {
            for (int index = 0; index < cookies.size(); ++index) {
                PacketField cookie = cookies.get(index);
                this.methodParamInJsonObject.put(cookie.getName(), cookie.getDatatype());
            }
        }
        if (this.serviceMethodGenerator.getRequestBodyClass() != null) {
            ObjectNode jsonRequestParam = this.composeRequestBody(this.serviceMethodGenerator.getCommonMethod().getRequest());
            this.methodParamInJsonObject.set("requestBody", (JsonNode)jsonRequestParam);
        }
    }

    public void processControllerMethod(CommonController commonController, JDefinedClass controllerClass) {
        List<PacketField> parameters;
        List<PacketField> pathVariables;
        List<PacketField> headVariables;
        String methodVersion;
        RequestMethod requestMethod = RequestMethod.POST;
        switch (this.serviceMethodGenerator.getCommonMethod().getHttpMethod().toUpperCase()) {
            case "GET": {
                requestMethod = RequestMethod.GET;
                break;
            }
            case "PUT": {
                requestMethod = RequestMethod.PUT;
                break;
            }
            case "DELETE": {
                requestMethod = RequestMethod.DELETE;
                break;
            }
            case "PATCH": {
                requestMethod = RequestMethod.PATCH;
                break;
            }
            case "HEAD": {
                requestMethod = RequestMethod.HEAD;
                break;
            }
            case "OPTIONS": {
                requestMethod = RequestMethod.OPTIONS;
                break;
            }
        }
        this.jcontrollerMethod = controllerClass.method(1, (AbstractJType)this.exchangeProcessor.getResponseClass(), this.serviceMethodGenerator.getMethodName());
        String methodRemark = this.serviceMethodGenerator.getCommonMethod().getRemark();
        this.jcontrollerMethod.javadoc().append((Object)methodRemark);
        String methodPath = this.serviceMethodGenerator.getCommonMethod().getPath();
        if (methodPath == null || methodPath.equals("")) {
            methodPath = "/" + this.serviceMethodGenerator.getCommonMethod().getName();
        }
        if ((methodVersion = this.serviceMethodGenerator.getCommonMethod().getVersion()) != null && !methodVersion.equals("")) {
            methodPath = methodPath + "/" + methodVersion;
        }
        JBlock controllerMethodBlk = this.jcontrollerMethod.body();
        JInvocation jInvocation = JExpr.invoke((IJExpression)JExpr.refthis((String)commonController.getServiceName()), (String)this.serviceMethodGenerator.getMethodName());
        methodPath = methodPath + this.exchangeProcessor.processHTTPRequest(this.jcontrollerMethod, jInvocation, this.mockModel, this.cm);
        if (this.getMockModel() == CodeGConstants.MockModel.MockModel_Swagger) {
            this.jcontrollerMethod.annotate(this.cm.ref("io.swagger.annotations.ApiOperation")).param("value", methodRemark).param("notes", methodRemark);
        }
        if ((headVariables = this.serviceMethodGenerator.getCommonMethod().getHeadVariables()) != null && headVariables.size() > 0) {
            for (int index = 0; index < headVariables.size(); ++index) {
                PacketField headVariable = headVariables.get(index);
                AbstractJClass jType = this.cm.ref(headVariable.getDatatype());
                JVar headVariableJVar = this.jcontrollerMethod.param((AbstractJType)jType, headVariable.getName());
                headVariableJVar.annotate(this.cm.ref("org.springframework.web.bind.annotation.RequestHeader")).param("name", headVariable.getName()).param("required", true);
                jInvocation.arg((IJExpression)headVariableJVar);
                if (this.getMockModel() != CodeGConstants.MockModel.MockModel_Swagger) continue;
                headVariableJVar.annotate(this.cm.ref("io.swagger.annotations.ApiParam")).param("name", headVariable.getName()).param("value", headVariable.getRemark()).param("required", true);
            }
        }
        if ((pathVariables = this.serviceMethodGenerator.getCommonMethod().getPathVariables()) != null && pathVariables.size() > 0) {
            for (int index = 0; index < pathVariables.size(); ++index) {
                PacketField pathVariable = pathVariables.get(index);
                AbstractJClass jType = this.cm.ref(pathVariable.getDatatype());
                JVar pathVariableJVar = this.jcontrollerMethod.param((AbstractJType)jType, pathVariable.getName());
                pathVariableJVar.annotate(this.cm.ref("org.springframework.web.bind.annotation.PathVariable")).param("name", pathVariable.getName()).param("required", true);
                methodPath = methodPath + "/{" + pathVariable.getName() + "}";
                jInvocation.arg((IJExpression)pathVariableJVar);
                if (this.getMockModel() != CodeGConstants.MockModel.MockModel_Swagger) continue;
                pathVariableJVar.annotate(this.cm.ref("io.swagger.annotations.ApiParam")).param("name", pathVariable.getName()).param("value", pathVariable.getRemark()).param("required", true);
            }
        }
        if ((parameters = this.serviceMethodGenerator.getCommonMethod().getParameters()) != null && parameters.size() > 0) {
            for (int index = 0; index < parameters.size(); ++index) {
                PacketField parameter = parameters.get(index);
                AbstractJClass jClass = this.cm.ref(parameter.getDatatype());
                JVar parameterJVar = this.jcontrollerMethod.param((AbstractJType)jClass, parameter.getName());
                parameterJVar.annotate(this.cm.ref("org.springframework.web.bind.annotation.RequestParam")).param("name", parameter.getName()).param("required", true);
                jInvocation.arg((IJExpression)parameterJVar);
                if (this.getMockModel() != CodeGConstants.MockModel.MockModel_Swagger) continue;
                parameterJVar.annotate(this.cm.ref("io.swagger.annotations.ApiParam")).param("name", parameter.getName()).param("value", parameter.getRemark()).param("required", true);
            }
        }
        JAnnotationUse jAnnotationUse = this.jcontrollerMethod.annotate(this.cm.ref("org.springframework.web.bind.annotation.RequestMapping"));
        jAnnotationUse.param("value", methodPath).param("method", (Enum)requestMethod);
        String[] resTypes = this.serviceMethodGenerator.getCommonMethod().getResType().split(",");
        if (resTypes.length == 1) {
            jAnnotationUse.param("produces", resTypes[0]);
        } else {
            JAnnotationArrayMember jAnnotationArrayMember = jAnnotationUse.paramArray("produces");
            for (int i = 0; i < resTypes.length; ++i) {
                jAnnotationArrayMember.param(resTypes[i]);
            }
        }
        List<PacketField> cookieVariables = this.serviceMethodGenerator.getCommonMethod().getCookieVariables();
        if (cookieVariables != null && cookieVariables.size() > 0) {
            for (int index = 0; index < cookieVariables.size(); ++index) {
                PacketField cookieVariable = cookieVariables.get(index);
                AbstractJClass jType = this.cm.ref(cookieVariable.getDatatype());
                JVar cookieJVar = this.jcontrollerMethod.param((AbstractJType)jType, cookieVariable.getName());
                cookieJVar.annotate(this.cm.ref("org.springframework.web.bind.annotation.CookieValue")).param("name", cookieVariable.getName()).param("required", true);
                jInvocation.arg((IJExpression)cookieJVar);
                if (this.getMockModel() == CodeGConstants.MockModel.MockModel_Swagger) {
                    cookieJVar.annotate(this.cm.ref("io.swagger.annotations.ApiParam")).param("name", cookieVariable.getName()).param("value", "cookie:" + cookieVariable.getRemark()).param("required", true);
                }
                controllerMethodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)(cookieJVar.name() + "{}"))).arg((IJExpression)cookieJVar));
            }
        }
        if (this.serviceMethodGenerator.getRequestBodyClass() != null) {
            JVar requestParam = this.jcontrollerMethod.param(this.serviceMethodGenerator.getRequestBodyClass(), "requestBody");
            requestParam.annotate(this.cm.ref("org.springframework.web.bind.annotation.RequestBody"));
            requestParam.annotate(this.cm.ref("javax.validation.Valid"));
            jInvocation.arg((IJExpression)JExpr.ref((String)"requestBody"));
        }
        this.exchangeProcessor.processResponse(controllerMethodBlk, jInvocation, this.cm);
    }
}

