/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.codeg.generator.method;

import com.fastjrun.codeg.common.PacketField;
import com.fastjrun.codeg.generator.method.BaseControllerMethodGenerator;
import com.fastjrun.codeg.helper.StringHelper;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldRef;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JVar;
import java.util.List;

public abstract class BaseHTTPMethodGenerator
extends BaseControllerMethodGenerator {
    public void processClientMethod(String controllerPath, JDefinedClass clientClass) {
        String methodVersion;
        this.jClientMethod = clientClass.method(1, this.serviceMethodGenerator.getResponseBodyClass(), this.serviceMethodGenerator.getMethodName());
        String methodRemark = this.serviceMethodGenerator.getCommonMethod().getRemark();
        this.jClientMethod.javadoc().append((Object)methodRemark);
        JBlock methodBlk = this.jClientMethod.body();
        this.jClientMethod.annotate(this.cm.ref("java.lang.Override"));
        String methodPath = this.serviceMethodGenerator.getCommonMethod().getPath();
        if (methodPath == null || methodPath.equals("")) {
            methodPath = "/" + this.serviceMethodGenerator.getMethodName();
        }
        if ((methodVersion = this.serviceMethodGenerator.getCommonMethod().getVersion()) != null && !methodVersion.equals("")) {
            methodPath = methodPath + "/" + methodVersion;
        }
        String invokeMethodName = this.serviceMethodGenerator.getCommonMethod().isResponseIsArray() ? "processList" : "process";
        JInvocation jInvocation = JExpr.invoke((IJExpression)JExpr.ref((String)"baseClient"), (String)invokeMethodName);
        List<PacketField> headVariables = this.serviceMethodGenerator.getCommonMethod().getHeadVariables();
        AbstractJClass stringClass = this.cm.ref("String");
        JVar headParamsJvar = null;
        if (headVariables != null && headVariables.size() > 0) {
            headParamsJvar = methodBlk.decl((AbstractJType)this.cm.ref("java.util.Map").narrow(stringClass).narrow(stringClass), "headParams", (IJExpression)JExpr._new((AbstractJType)this.cm.ref("java.util.HashMap").narrow(stringClass).narrow(stringClass)));
            for (int index = 0; index < headVariables.size(); ++index) {
                PacketField headVariable = headVariables.get(index);
                AbstractJClass jClass = this.cm.ref(headVariable.getDatatype());
                this.jClientMethod.param((AbstractJType)jClass, headVariable.getNameAlias());
                methodBlk.add((IJStatement)headParamsJvar.invoke("put").arg((IJExpression)JExpr.lit((String)headVariable.getName())).arg((IJExpression)JExpr.ref((String)headVariable.getNameAlias())));
                methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"header[{}] = {}")).arg((IJExpression)JExpr.lit((String)headVariable.getNameAlias())).arg((IJExpression)JExpr.ref((String)headVariable.getNameAlias())));
            }
        }
        AbstractJClass stringBuilderClass = this.cm.ref("java.lang.StringBuilder");
        JVar pathVar = methodBlk.decl((AbstractJType)stringBuilderClass, "path", (IJExpression)JExpr._new((AbstractJType)stringBuilderClass).invoke("append").arg(JExpr.lit((String)controllerPath).plus((IJExpression)JExpr.lit((String)methodPath))));
        List<PacketField> pathVariables = this.serviceMethodGenerator.getCommonMethod().getPathVariables();
        if (pathVariables != null && pathVariables.size() > 0) {
            for (int index = 0; index < pathVariables.size(); ++index) {
                PacketField pathVariable = pathVariables.get(index);
                AbstractJClass jClass = this.cm.ref(pathVariable.getDatatype());
                this.jClientMethod.param((AbstractJType)jClass, pathVariable.getName());
                methodBlk.add((IJStatement)pathVar.invoke("append").arg((IJExpression)JExpr.lit((String)"/")));
                methodBlk.add((IJStatement)pathVar.invoke("append").arg((IJExpression)JExpr.ref((String)pathVariable.getName())));
                methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"pathVariable[{}] = {}")).arg((IJExpression)JExpr.lit((String)pathVariable.getName())).arg((IJExpression)JExpr.ref((String)pathVariable.getName())));
            }
        }
        jInvocation.arg((IJExpression)pathVar.invoke("toString"));
        methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"path = {}")).arg((IJExpression)pathVar.invoke("toString")));
        jInvocation.arg((IJExpression)JExpr.lit((String)this.serviceMethodGenerator.getCommonMethod().getHttpMethod().toUpperCase()));
        methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"method = {}")).arg(this.serviceMethodGenerator.getCommonMethod().getHttpMethod().toUpperCase()));
        List<PacketField> parameters = this.serviceMethodGenerator.getCommonMethod().getParameters();
        if (parameters != null && parameters.size() > 0) {
            JVar queryParamsJvar = methodBlk.decl((AbstractJType)this.cm.ref("java.util.Map").narrow(stringClass).narrow(stringClass), "queryParams", (IJExpression)JExpr._new((AbstractJType)this.cm.ref("java.util.HashMap").narrow(stringClass).narrow(stringClass)));
            for (int index = 0; index < parameters.size(); ++index) {
                PacketField parameter = parameters.get(index);
                AbstractJClass jClass = this.cm.ref(parameter.getDatatype());
                this.jClientMethod.param((AbstractJType)jClass, parameter.getName());
                IJExpression jInvocationParameter = JExpr.direct((String)parameter.getName());
                if (jClass != stringClass) {
                    jInvocationParameter = stringClass.staticInvoke("valueOf").arg(jInvocationParameter);
                }
                methodBlk.add((IJStatement)queryParamsJvar.invoke("put").arg((IJExpression)JExpr.lit((String)parameter.getName())).arg(jInvocationParameter));
                methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"paramter[{}] = {}")).arg((IJExpression)JExpr.lit((String)parameter.getName())).arg((IJExpression)JExpr.ref((String)parameter.getName())));
            }
            jInvocation.arg((IJExpression)queryParamsJvar);
        } else {
            jInvocation.arg((IJExpression)JExpr._null());
        }
        if (headParamsJvar != null) {
            jInvocation.arg((IJExpression)headParamsJvar);
        } else {
            jInvocation.arg((IJExpression)JExpr._null());
        }
        List<PacketField> cookies = this.serviceMethodGenerator.getCommonMethod().getCookieVariables();
        if (cookies != null && cookies.size() > 0) {
            JVar cookieJvar = methodBlk.decl((AbstractJType)this.cm.ref("java.util.Map").narrow(stringClass).narrow(stringClass), "cookieParams", (IJExpression)JExpr._new((AbstractJType)this.cm.ref("java.util.HashMap").narrow(stringClass).narrow(stringClass)));
            for (int index = 0; index < cookies.size(); ++index) {
                PacketField cookie = cookies.get(index);
                AbstractJClass jClass = this.cm.ref(cookie.getDatatype());
                this.jClientMethod.param((AbstractJType)jClass, cookie.getName());
                JFieldRef jInvocationCookie = JExpr.ref((String)cookie.getName());
                if (jClass != stringClass) {
                    jInvocationCookie = stringClass.staticInvoke("valueOf").arg((IJExpression)jInvocationCookie);
                }
                methodBlk.add((IJStatement)cookieJvar.invoke("put").arg((IJExpression)JExpr.lit((String)cookie.getName())).arg((IJExpression)jInvocationCookie));
                methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"paramter[{}] = {}")).arg((IJExpression)JExpr.lit((String)cookie.getName())).arg((IJExpression)JExpr.ref((String)cookie.getName())));
            }
            jInvocation.arg((IJExpression)cookieJvar);
        } else {
            jInvocation.arg((IJExpression)JExpr._null());
        }
        if (this.serviceMethodGenerator.getRequestBodyClass() != null) {
            JVar jRequestBodyVar = this.jClientMethod.param(this.serviceMethodGenerator.getRequestBodyClass(), "requestBody");
            jInvocation.arg((IJExpression)jRequestBodyVar);
        } else {
            jInvocation.arg((IJExpression)JExpr._null());
        }
        if (this.serviceMethodGenerator.getResponseBodyClass() != null && this.serviceMethodGenerator.getResponseBodyClass() != this.cm.VOID) {
            if (this.serviceMethodGenerator.getElementClass() != null) {
                jInvocation.arg(JExpr.dotClass((AbstractJType)this.serviceMethodGenerator.getElementClass()));
            } else {
                jInvocation.arg(JExpr.dotClass((AbstractJType)this.serviceMethodGenerator.getResponseBodyClass()));
            }
            methodBlk._return((IJExpression)jInvocation);
        } else {
            methodBlk.add((IJStatement)jInvocation);
        }
    }

    @Override
    public void generate() {
        if (!this.isApi()) {
            if (this.isClient()) {
                this.processClientMethod(this.baseControllerGenerator.getControllerPath(), this.baseControllerGenerator.getClientClass());
                this.processClientTestMethod(this.baseControllerGenerator.getClientTestClass());
                StringBuilder sb = new StringBuilder(this.baseControllerGenerator.getClientName()).append("Test.test");
                sb.append(StringHelper.toUpperCaseFirstOne(this.serviceMethodGenerator.getMethodName())).append(".n");
                this.processClientTestPraram();
                this.baseControllerGenerator.getClientTestParam().put(sb.toString(), this.methodParamInJsonObject.toString().replaceAll("\n", "").replaceAll("\r", "").trim());
            } else {
                this.processControllerMethod(this.baseControllerGenerator.getCommonController(), this.baseControllerGenerator.getControlllerClass());
            }
        }
    }
}

