/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.codeg.generator.method;

import com.fastjrun.codeg.common.CodeGConstants;
import com.fastjrun.codeg.common.CommonController;
import com.fastjrun.codeg.common.PacketField;
import com.fastjrun.codeg.generator.BaseRPCGenerator;
import com.fastjrun.codeg.generator.method.BaseControllerMethodGenerator;
import com.fastjrun.codeg.generator.method.MethodGeneratorHelper;
import com.fastjrun.codeg.helper.StringHelper;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.type.PrimitiveType;

public abstract class BaseRPCMethodGenerator
extends BaseControllerMethodGenerator {
    protected JMethod japiMethod;
    protected JMethod japiManagerMethod;

    public void processApiMethod(JDefinedClass apiClass) {
        this.japiMethod = apiClass.method(0, (AbstractJType)this.exchangeProcessor.getResponseClass(), this.serviceMethodGenerator.getMethodName());
        String methodRemark = this.serviceMethodGenerator.getCommonMethod().getRemark();
        this.japiMethod.javadoc().append((Object)methodRemark);
        MethodGeneratorHelper.processServiceMethodVariables(this.japiMethod, this.serviceMethodGenerator.getCommonMethod().getHeadVariables(), this.cm);
        MethodGeneratorHelper.processServiceMethodVariables(this.japiMethod, this.serviceMethodGenerator.getCommonMethod().getPathVariables(), this.cm);
        MethodGeneratorHelper.processServiceMethodVariables(this.japiMethod, this.serviceMethodGenerator.getCommonMethod().getParameters(), this.cm);
        MethodGeneratorHelper.processServiceMethodVariables(this.japiMethod, this.serviceMethodGenerator.getCommonMethod().getCookieVariables(), this.cm);
        if (this.exchangeProcessor.getRequestClass() != null) {
            this.japiMethod.param(this.exchangeProcessor.getRequestClass(), "request");
        }
    }

    public void processApiManagerMethod(CommonController commonController, JDefinedClass apiManagerClass) {
        List<PacketField> cookieVariables;
        List<PacketField> parameters;
        List<PacketField> pathVariables;
        this.japiManagerMethod = apiManagerClass.method(1, (AbstractJType)this.exchangeProcessor.getResponseClass(), this.serviceMethodGenerator.getMethodName());
        String methodRemark = this.serviceMethodGenerator.getCommonMethod().getRemark();
        this.japiManagerMethod.javadoc().append((Object)methodRemark);
        String serviceName = commonController.getServiceName();
        JInvocation jInvocation = JExpr.invoke((IJExpression)JExpr.refthis((String)serviceName), (String)this.serviceMethodGenerator.getMethodName());
        this.japiManagerMethod.annotate(this.cm.ref("java.lang.Override"));
        List<PacketField> headVariables = this.serviceMethodGenerator.getCommonMethod().getHeadVariables();
        if (headVariables != null && headVariables.size() > 0) {
            for (int index = 0; index < headVariables.size(); ++index) {
                PacketField headVariable = headVariables.get(index);
                AbstractJClass jType = this.cm.ref(headVariable.getDatatype());
                JVar headVariableJVar = this.japiManagerMethod.param((AbstractJType)jType, headVariable.getName());
                jInvocation.arg((IJExpression)headVariableJVar);
            }
        }
        if ((pathVariables = this.serviceMethodGenerator.getCommonMethod().getPathVariables()) != null && pathVariables.size() > 0) {
            for (int index = 0; index < pathVariables.size(); ++index) {
                PacketField pathVariable = pathVariables.get(index);
                AbstractJClass jType = this.cm.ref(pathVariable.getDatatype());
                JVar pathVariableJVar = this.japiManagerMethod.param((AbstractJType)jType, pathVariable.getName());
                jInvocation.arg((IJExpression)pathVariableJVar);
            }
        }
        if ((parameters = this.serviceMethodGenerator.getCommonMethod().getParameters()) != null && parameters.size() > 0) {
            for (int index = 0; index < parameters.size(); ++index) {
                PacketField parameter = parameters.get(index);
                AbstractJClass jClass = this.cm.ref(parameter.getDatatype());
                JVar parameterJVar = this.japiManagerMethod.param((AbstractJType)jClass, parameter.getName());
                jInvocation.arg((IJExpression)parameterJVar);
            }
        }
        if ((cookieVariables = this.serviceMethodGenerator.getCommonMethod().getCookieVariables()) != null && cookieVariables.size() > 0) {
            for (int index = 0; index < cookieVariables.size(); ++index) {
                PacketField cookieVariable = cookieVariables.get(index);
                AbstractJClass jType = this.cm.ref(cookieVariable.getDatatype());
                JVar cookieJVar = this.japiManagerMethod.param((AbstractJType)jType, cookieVariable.getName());
                jInvocation.arg((IJExpression)cookieJVar);
            }
        }
        this.exchangeProcessor.processRPCRequest(this.japiManagerMethod, jInvocation, this.cm);
        this.exchangeProcessor.processResponse(this.japiManagerMethod.body(), jInvocation, this.cm);
    }

    public void processClientMethod(AbstractJClass apiClass, JDefinedClass clientClass) {
        List<PacketField> cookies;
        List<PacketField> parameters;
        List<PacketField> pathVariables;
        this.jClientMethod = clientClass.method(1, this.serviceMethodGenerator.getResponseBodyClass(), this.serviceMethodGenerator.getMethodName());
        String methodRemark = this.serviceMethodGenerator.getCommonMethod().getRemark();
        this.jClientMethod.javadoc().append((Object)methodRemark);
        this.jClientMethod.annotate(this.cm.ref("java.lang.Override"));
        JBlock methodBlk = this.jClientMethod.body();
        String invokeMethodName = this.serviceMethodGenerator.getCommonMethod().isResponseIsArray() ? "processList" : "process";
        JInvocation jInvocation = JExpr.invoke((IJExpression)JExpr.ref((String)"baseClient"), (String)invokeMethodName);
        jInvocation.arg(JExpr.dotClass((AbstractJType)apiClass));
        jInvocation.arg((IJExpression)JExpr.lit((String)this.serviceMethodGenerator.getMethodName()));
        ArrayList<Object> paramterTypes = new ArrayList<Object>();
        ArrayList<JVar> paramterJVars = new ArrayList<JVar>();
        List<PacketField> headVariables = this.serviceMethodGenerator.getCommonMethod().getHeadVariables();
        if (headVariables != null && headVariables.size() > 0) {
            for (int index = 0; index < headVariables.size(); ++index) {
                PacketField headVariable = headVariables.get(index);
                AbstractJClass jClass = this.cm.ref(headVariable.getDatatype());
                JVar headJVar = this.jClientMethod.param((AbstractJType)jClass, headVariable.getNameAlias());
                paramterTypes.add(jClass);
                paramterJVars.add(headJVar);
                methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"header[{}] = {}")).arg((IJExpression)JExpr.lit((String)headVariable.getNameAlias())).arg((IJExpression)JExpr.ref((String)headVariable.getNameAlias())));
            }
        }
        if ((pathVariables = this.serviceMethodGenerator.getCommonMethod().getPathVariables()) != null && pathVariables.size() > 0) {
            for (int index = 0; index < pathVariables.size(); ++index) {
                PacketField pathVariable = pathVariables.get(index);
                AbstractJClass jClass = this.cm.ref(pathVariable.getDatatype());
                JVar pathVariableVar = this.jClientMethod.param((AbstractJType)jClass, pathVariable.getName());
                paramterTypes.add(jClass);
                paramterJVars.add(pathVariableVar);
                methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"pathVariable[{}] = {}")).arg((IJExpression)JExpr.lit((String)pathVariable.getName())).arg((IJExpression)JExpr.ref((String)pathVariable.getName())));
            }
        }
        if ((parameters = this.serviceMethodGenerator.getCommonMethod().getParameters()) != null && parameters.size() > 0) {
            for (int index = 0; index < parameters.size(); ++index) {
                PacketField parameter = parameters.get(index);
                AbstractJClass jClass = this.cm.ref(parameter.getDatatype());
                JVar parameterVar = this.jClientMethod.param((AbstractJType)jClass, parameter.getName());
                paramterTypes.add(jClass);
                paramterJVars.add(parameterVar);
                methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"paramter[{}] = {}")).arg((IJExpression)JExpr.lit((String)parameter.getName())).arg((IJExpression)JExpr.ref((String)parameter.getName())));
            }
        }
        if ((cookies = this.serviceMethodGenerator.getCommonMethod().getCookieVariables()) != null && cookies.size() > 0) {
            for (int index = 0; index < cookies.size(); ++index) {
                PacketField cookie = cookies.get(index);
                AbstractJClass jClass = this.cm.ref(cookie.getDatatype());
                JVar cookieVar = this.jClientMethod.param((AbstractJType)jClass, cookie.getName());
                paramterTypes.add(jClass);
                paramterJVars.add(cookieVar);
                methodBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"paramter[{}] = {}")).arg((IJExpression)JExpr.lit((String)cookie.getName())).arg((IJExpression)JExpr.ref((String)cookie.getName())));
            }
        }
        if (this.serviceMethodGenerator.getRequestBodyClass() != null) {
            JVar jRequestBodyVar = this.jClientMethod.param(this.serviceMethodGenerator.getRequestBodyClass(), "requestBody");
            paramterTypes.add(this.exchangeProcessor.getRequestClass());
            paramterJVars.add(jRequestBodyVar);
        }
        if (paramterTypes.size() > 0) {
            JVar paramterTypesJVar = methodBlk.decl((AbstractJType)this.cm.ref("Class").array(), "paramterTypes", (IJExpression)JExpr.newArray((AbstractJType)this.cm.ref("Class"), (int)paramterTypes.size()));
            JVar paramterValuesJVar = methodBlk.decl((AbstractJType)this.cm.ref("Object").array(), "paramterValues", (IJExpression)JExpr.newArray((AbstractJType)this.cm.ref("Object"), (int)paramterJVars.size()));
            for (int i = 0; i < paramterJVars.size(); ++i) {
                methodBlk.assign((IJAssignmentTarget)paramterTypesJVar.component((IJExpression)JExpr.lit((int)i)), (IJExpression)((JVar)paramterJVars.get(i)).invoke("getClass"));
                methodBlk.assign((IJAssignmentTarget)paramterValuesJVar.component((IJExpression)JExpr.lit((int)i)), (IJExpression)paramterJVars.get(i));
            }
            jInvocation.arg((IJExpression)paramterTypesJVar);
            jInvocation.arg((IJExpression)paramterValuesJVar);
        }
        if (this.serviceMethodGenerator.getResponseBodyClass() != null && this.serviceMethodGenerator.getResponseBodyClass() != this.cm.VOID) {
            AbstractJType responseType = this.serviceMethodGenerator.getResponseBodyClass();
            AbstractJClass responseClass = null;
            responseClass = responseType instanceof PrimitiveType ? responseType.boxify() : (AbstractJClass)responseType;
            jInvocation.arg(responseClass.dotclass());
            methodBlk._return((IJExpression)jInvocation);
        } else {
            jInvocation.arg((IJExpression)JExpr._null());
            methodBlk.add((IJStatement)jInvocation);
        }
    }

    @Override
    public void generate() {
        if (this.baseControllerGenerator.getCommonController().is_new()) {
            this.processApiMethod((JDefinedClass)((BaseRPCGenerator)this.baseControllerGenerator).getApiClass());
        }
        if (!this.isApi()) {
            if (this.isClient()) {
                this.processClientMethod(((BaseRPCGenerator)this.baseControllerGenerator).getApiClass(), this.baseControllerGenerator.getClientClass());
                this.processClientTestMethod(this.baseControllerGenerator.getClientTestClass());
                StringBuilder sb = new StringBuilder(this.baseControllerGenerator.getClientName()).append("Test.test");
                sb.append(StringHelper.toUpperCaseFirstOne(this.serviceMethodGenerator.getMethodName())).append(".n");
                this.processClientTestPraram();
                this.baseControllerGenerator.getClientTestParam().put(sb.toString(), this.methodParamInJsonObject.toString().replaceAll("\n", "").replaceAll("\r", "").trim());
            } else {
                if (this.getMockModel() != CodeGConstants.MockModel.MockModel_Common) {
                    this.processControllerMethod(this.baseControllerGenerator.getCommonController(), this.baseControllerGenerator.getControlllerClass());
                }
                this.processApiManagerMethod(this.baseControllerGenerator.getCommonController(), ((BaseRPCGenerator)this.baseControllerGenerator).getApiManagerClass());
            }
        }
    }
}

