/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.codeg.generator.method;

import com.fastjrun.codeg.common.PacketField;
import com.fastjrun.codeg.common.PacketObject;
import com.fastjrun.codeg.generator.common.BaseCMGenerator;
import com.fastjrun.helper.StringHelper;
import com.fastjrun.utils.JacksonUtils;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JForLoop;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class MethodGeneratorHelper {
    public static void processServiceMethodVariables(JMethod jmethod, List<PacketField> variables, JCodeModel cm) {
        if (variables != null && variables.size() > 0) {
            for (int index = 0; index < variables.size(); ++index) {
                PacketField variable = variables.get(index);
                AbstractJClass jType = cm.ref(variable.getDatatype());
                jmethod.param((AbstractJType)jType, variable.getName());
            }
        }
    }

    public static void processMethodCommonVariables(JCodeModel cmTest, JBlock methodTestBlk, JVar reqParamsJsonJVar, PacketField parameter) {
        AbstractJClass jType = cmTest.ref(parameter.getDatatype());
        String paramterName = parameter.getName();
        if (parameter.getNameAlias() != null && !parameter.getNameAlias().equals("")) {
            paramterName = parameter.getNameAlias();
        }
        JVar jVar = methodTestBlk.decl((AbstractJType)jType, paramterName, (IJExpression)JExpr._null());
        JVar jJsonVar = methodTestBlk.decl((AbstractJType)cmTest.ref(BaseCMGenerator.JSONOBJECTCLASS_NAME), paramterName + "jSon", (IJExpression)reqParamsJsonJVar.invoke("get").arg((IJExpression)JExpr.lit((String)paramterName)));
        JBlock jNotNullBlock = methodTestBlk._if(jJsonVar.ne((IJExpression)JExpr._null()))._then();
        String jsonInvokeMethodName = JacksonUtils.invokeMethodName((String)jType.name());
        jNotNullBlock.assign((IJAssignmentTarget)jVar, (IJExpression)jJsonVar.invoke(jsonInvokeMethodName));
    }

    private static void logResponseBodyField(JCodeModel cmTest, Logger log, int loopSeq, PacketObject responseBody, JVar responseBodyVar, JBlock methodTestBlk) {
        Map<String, PacketField> fields = responseBody.getFields();
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                String getter;
                String char2;
                String tterMethodName;
                AbstractJClass jType;
                PacketField restField = fields.get(fieldName);
                boolean canBeNull = restField.isCanBeNull();
                String dataType = restField.getDatatype();
                AbstractJClass primitiveType = null;
                if (dataType.endsWith(":List")) {
                    primitiveType = cmTest.ref(dataType.split(":")[0]);
                    jType = cmTest.ref("java.util.List").narrow(primitiveType);
                } else {
                    jType = cmTest.ref(dataType);
                }
                String lengthInString = restField.getLength();
                int length = 0;
                if (!"".equals(lengthInString)) {
                    try {
                        length = Integer.parseInt(lengthInString);
                    }
                    catch (Exception e) {
                        log.error(fieldName + "'s length is assigned a wrong value", (Throwable)e);
                    }
                }
                if ((tterMethodName = fieldName).length() > 1 && !(char2 = String.valueOf(tterMethodName.charAt(1))).equals(char2.toUpperCase())) {
                    tterMethodName = StringHelper.toUpperCaseFirstOne((String)tterMethodName);
                }
                if ((getter = restField.getGetter()) == null || getter.equals("")) {
                    getter = "get" + tterMethodName;
                }
                JVar fieldNameVar = methodTestBlk.decl((AbstractJType)jType, StringHelper.toLowerCaseFirstOne((String)responseBodyVar.type().name()) + loopSeq + tterMethodName, (IJExpression)responseBodyVar.invoke(getter));
                methodTestBlk.add((IJStatement)JExpr.ref((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)(fieldNameVar.name() + "{}"))).arg((IJExpression)fieldNameVar));
                if (!canBeNull) {
                    methodTestBlk.add((IJStatement)cmTest.ref("org.testng.Assert").staticInvoke("assertNotNull").arg((IJExpression)fieldNameVar));
                }
                if (primitiveType != null || !jType.name().equals("String")) continue;
                JBlock ifBlock1 = methodTestBlk._if(fieldNameVar.ne((IJExpression)JExpr._null()))._then();
                ifBlock1.decl((AbstractJType)cmTest.INT, "actualLength", (IJExpression)fieldNameVar.invoke("length"));
                JBlock ifBlock2 = ifBlock1._if(JExpr.ref((String)"actualLength").gt((IJExpression)JExpr.lit((int)length)))._then();
                StringBuilder sbFailReason = new StringBuilder();
                sbFailReason.append(fieldName);
                sbFailReason.append("'s length defined as ");
                sbFailReason.append(length);
                sbFailReason.append(",but returned value's length is ");
                ifBlock2.add((IJStatement)cmTest.ref("org.testng.Assert").staticInvoke("fail").arg(JExpr.lit((String)sbFailReason.toString()).plus((IJExpression)JExpr.ref((String)"actualLength"))));
            }
        }
    }

    public static void logResponseBody(JCodeModel cmTest, Logger log, String packageNamePrefix, int loopSeq, PacketObject responseBody, JVar responseBodyVar, JBlock methodTestBlk) {
        Map<String, PacketObject> roLists;
        MethodGeneratorHelper.logResponseBodyField(cmTest, log, loopSeq, responseBody, responseBodyVar, methodTestBlk);
        int start = 1;
        Map<String, PacketObject> robjects = responseBody.getObjects();
        if (robjects != null && robjects.size() > 0) {
            for (String reName : robjects.keySet()) {
                String char2;
                PacketObject ro = robjects.get(reName);
                String tterMethodName = reName;
                if (reName.length() > 1 && !(char2 = String.valueOf(reName.charAt(1))).equals(char2.toUpperCase())) {
                    tterMethodName = StringHelper.toUpperCaseFirstOne((String)reName);
                }
                AbstractJClass roClass = ro.is_new() ? cmTest.ref(packageNamePrefix + ro.get_class()) : cmTest.ref(ro.get_class());
                JVar reNameVar = methodTestBlk.decl((AbstractJType)roClass, responseBody.getName() + tterMethodName + loopSeq, (IJExpression)responseBodyVar.invoke("get" + tterMethodName));
                MethodGeneratorHelper.logResponseBody(cmTest, log, packageNamePrefix, loopSeq + start++, ro, reNameVar, methodTestBlk);
            }
        }
        if ((roLists = responseBody.getLists()) != null && roLists.size() > 0) {
            int index = 0;
            for (String roName : roLists.keySet()) {
                String char2;
                PacketObject ro = roLists.get(roName);
                String tterMethodName = roName;
                if (roName.length() > 1 && !(char2 = String.valueOf(roName.charAt(1))).equals(char2.toUpperCase())) {
                    tterMethodName = StringHelper.toUpperCaseFirstOne((String)roName);
                }
                AbstractJClass roClass = ro.is_new() ? cmTest.ref(packageNamePrefix + ro.get_class()) : cmTest.ref(ro.get_class());
                JVar roListVar = methodTestBlk.decl((AbstractJType)cmTest.ref("java.util.List").narrow(roClass), responseBody.getName() + tterMethodName + "List" + loopSeq + index, (IJExpression)responseBodyVar.invoke("get" + tterMethodName));
                JBlock ifBlock1 = methodTestBlk._if(roListVar.ne((IJExpression)JExpr._null()))._then();
                JForLoop forLoop = ifBlock1._for();
                JVar initIndexVar = forLoop.init((AbstractJType)cmTest.INT, responseBody.getName() + tterMethodName + "ListIndex" + loopSeq + index, (IJExpression)JExpr.lit((int)0));
                forLoop.test(initIndexVar.lt((IJExpression)roListVar.invoke("size")));
                forLoop.update(initIndexVar.incr());
                JBlock forBlock1 = forLoop.body();
                JVar responseBodyIndexVar = forBlock1.decl((AbstractJType)roClass, roName + roClass.name(), (IJExpression)roListVar.invoke("get").arg((IJExpression)initIndexVar));
                MethodGeneratorHelper.logResponseBody(cmTest, log, packageNamePrefix, loopSeq + start++, ro, responseBodyIndexVar, forBlock1);
                ++index;
            }
        }
    }
}

