/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.codeg.generator.method;

import com.fastjrun.codeg.common.CodeGConstants;
import com.fastjrun.codeg.common.CodeGException;
import com.fastjrun.codeg.common.CommonMethod;
import com.fastjrun.codeg.common.PacketField;
import com.fastjrun.codeg.common.PacketObject;
import com.fastjrun.codeg.generator.ServiceGenerator;
import com.fastjrun.codeg.generator.method.AbstractMethodGenerator;
import com.fastjrun.codeg.generator.method.MethodGeneratorHelper;
import com.fastjrun.helper.StringHelper;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAnnotationUse;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCatchBlock;
import com.helger.jcodemodel.JConditional;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JForLoop;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JTryBlock;
import com.helger.jcodemodel.JVar;
import java.util.List;
import java.util.Map;

public class ServiceMethodGenerator
extends AbstractMethodGenerator {
    static String mockHelperClassName = "com.fastjrun.helper.MockHelper";
    protected CommonMethod commonMethod;
    protected String methodName;
    protected JMethod jServiceMethod;
    protected JMethod jServiceMockMethod;
    protected AbstractJType requestBodyClass;
    protected AbstractJType responseBodyClass;
    protected AbstractJClass elementClass;
    protected ServiceGenerator serviceGenerator;
    protected JFieldVar fieldVar;

    public JFieldVar getFieldVar() {
        return this.fieldVar;
    }

    public void setFieldVar(JFieldVar fieldVar) {
        this.fieldVar = fieldVar;
    }

    public ServiceGenerator getServiceGenerator() {
        return this.serviceGenerator;
    }

    public void setServiceGenerator(ServiceGenerator serviceGenerator) {
        this.serviceGenerator = serviceGenerator;
    }

    public AbstractJType getResponseBodyClass() {
        return this.responseBodyClass;
    }

    public void setResponseBodyClass(AbstractJType responseBodyClass) {
        this.responseBodyClass = responseBodyClass;
    }

    public AbstractJClass getElementClass() {
        return this.elementClass;
    }

    public void setElementClass(AbstractJClass elementClass) {
        this.elementClass = elementClass;
    }

    public AbstractJType getRequestBodyClass() {
        return this.requestBodyClass;
    }

    public void setRequestBodyClass(AbstractJType requestBodyClass) {
        this.requestBodyClass = requestBodyClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public JMethod getjServiceMethod() {
        return this.jServiceMethod;
    }

    public void setjServiceMethod(JMethod jServiceMethod) {
        this.jServiceMethod = jServiceMethod;
    }

    public JMethod getjServiceMockMethod() {
        return this.jServiceMockMethod;
    }

    public void setjServiceMockMethod(JMethod jServiceMockMethod) {
        this.jServiceMockMethod = jServiceMockMethod;
    }

    public CommonMethod getCommonMethod() {
        return this.commonMethod;
    }

    public void setCommonMethod(CommonMethod commonMethod) {
        this.commonMethod = commonMethod;
    }

    public void doParse() {
        PacketObject response;
        PacketObject request = this.commonMethod.getRequest();
        if (request != null) {
            this.requestBodyClass = request.is_new() ? this.cm.ref(this.packageNamePrefix + request.get_class()) : this.cm.ref(request.get_class());
        }
        if ((response = this.commonMethod.getResponse()) == null) {
            this.responseBodyClass = this.cm.VOID;
        } else {
            String responseClassP = response.get_class();
            this.elementClass = response.is_new() ? this.cm.ref(this.packageNamePrefix + responseClassP) : this.cm.ref(responseClassP);
            this.responseBodyClass = this.commonMethod.isResponseIsArray() ? this.cm.ref("java.util.List").narrow(this.elementClass) : this.elementClass;
        }
    }

    public void processServiceMethod() {
        this.jServiceMethod = this.serviceGenerator.getServiceClass().method(0, this.responseBodyClass, this.methodName);
        String methodRemark = this.commonMethod.getRemark();
        this.jServiceMethod.javadoc().append((Object)methodRemark);
        MethodGeneratorHelper.processServiceMethodVariables(this.jServiceMethod, this.commonMethod.getHeadVariables(), this.cm);
        MethodGeneratorHelper.processServiceMethodVariables(this.jServiceMethod, this.commonMethod.getPathVariables(), this.cm);
        MethodGeneratorHelper.processServiceMethodVariables(this.jServiceMethod, this.commonMethod.getParameters(), this.cm);
        MethodGeneratorHelper.processServiceMethodVariables(this.jServiceMethod, this.commonMethod.getCookieVariables(), this.cm);
        if (this.requestBodyClass != null) {
            this.jServiceMethod.param(this.requestBodyClass, "requestBody");
        }
    }

    public void processServiceTestMethod() {
        List<PacketField> cookies;
        List<PacketField> parameters;
        List<PacketField> pathVariables;
        JDefinedClass serviceTestClass = this.serviceGenerator.getServiceTestClass();
        JMethod jServiceTestMethod = serviceTestClass.method(1, (AbstractJType)this.cmTest.VOID, "test" + StringHelper.toUpperCaseFirstOne((String)this.methodName));
        JAnnotationUse methodTestAnnotationTest = jServiceTestMethod.annotate(this.cmTest.ref("org.testng.annotations.Test"));
        JBlock methodTestBlk = jServiceTestMethod.body();
        methodTestAnnotationTest.param("dataProvider", "loadParam");
        JVar reqParamsJsonStrAndAssertJVar = jServiceTestMethod.param((AbstractJType)this.cmTest.ref("String"), "reqParamsJsonStrAndAssert");
        JVar jsonNodes = methodTestBlk.decl((AbstractJType)this.cmTest.ref("com.fasterxml.jackson.databind.JsonNode").array(), "jsonNodes", (IJExpression)JExpr.invoke((String)"parseStr2JsonArray").arg((IJExpression)reqParamsJsonStrAndAssertJVar));
        JVar reqParamsJsonJVar = methodTestBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "reqParamsJson", (IJExpression)jsonNodes.component(0));
        JVar assertJsonJVar = methodTestBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "assertJson", (IJExpression)jsonNodes.component(1));
        JInvocation jInvocationTest = JExpr.invoke((IJExpression)this.fieldVar, (String)this.methodName);
        AbstractJClass exceptionClass = this.cmTest.ref("com.fastjrun.common.ServiceException");
        List<PacketField> headVariables = this.getCommonMethod().getHeadVariables();
        if (headVariables != null && headVariables.size() > 0) {
            for (int index = 0; index < headVariables.size(); ++index) {
                PacketField headVariable = headVariables.get(index);
                jInvocationTest.arg((IJExpression)JExpr.ref((String)headVariable.getNameAlias()));
                MethodGeneratorHelper.processMethodCommonVariables(this.cmTest, methodTestBlk, reqParamsJsonJVar, headVariable);
            }
        }
        if ((pathVariables = this.getCommonMethod().getPathVariables()) != null && pathVariables.size() > 0) {
            for (int index = 0; index < pathVariables.size(); ++index) {
                PacketField pathVariable = pathVariables.get(index);
                jInvocationTest.arg((IJExpression)JExpr.ref((String)pathVariable.getName()));
                MethodGeneratorHelper.processMethodCommonVariables(this.cmTest, methodTestBlk, reqParamsJsonJVar, pathVariable);
            }
        }
        if ((parameters = this.getCommonMethod().getParameters()) != null && parameters.size() > 0) {
            for (int index = 0; index < parameters.size(); ++index) {
                PacketField parameter = parameters.get(index);
                jInvocationTest.arg((IJExpression)JExpr.ref((String)parameter.getName()));
                MethodGeneratorHelper.processMethodCommonVariables(this.cmTest, methodTestBlk, reqParamsJsonJVar, parameter);
            }
        }
        if ((cookies = this.getCommonMethod().getCookieVariables()) != null && cookies.size() > 0) {
            for (int index = 0; index < cookies.size(); ++index) {
                PacketField cookie = cookies.get(index);
                jInvocationTest.arg((IJExpression)JExpr.ref((String)cookie.getName()));
                MethodGeneratorHelper.processMethodCommonVariables(this.cmTest, methodTestBlk, reqParamsJsonJVar, cookie);
            }
        }
        if (this.getRequestBodyClass() != null) {
            JVar requestBodyVar = methodTestBlk.decl(this.getRequestBodyClass(), "requestBody", (IJExpression)JExpr._null());
            JVar requestBodyStrVar = methodTestBlk.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "reqJsonRequestBody", (IJExpression)reqParamsJsonJVar.invoke("get").arg((IJExpression)JExpr.lit((String)"requestBody")));
            JBlock jNotNullBlock = methodTestBlk._if(requestBodyStrVar.ne((IJExpression)JExpr._null()))._then();
            jNotNullBlock.assign((IJAssignmentTarget)requestBodyVar, (IJExpression)this.cmTest.ref("com.fastjrun.utils.JacksonUtils").staticInvoke("readValue").arg((IJExpression)requestBodyStrVar.invoke("toString")).arg(((AbstractJClass)this.getRequestBodyClass()).dotclass()));
            jInvocationTest.arg((IJExpression)requestBodyVar);
        }
        if (this.getResponseBodyClass() != this.cm.VOID) {
            JVar responseBodyVar = methodTestBlk.decl(this.getResponseBodyClass(), "responseBody", (IJExpression)JExpr._null());
            JConditional jConditional1 = methodTestBlk._if(assertJsonJVar.ne((IJExpression)JExpr._null()));
            JBlock jConditional1Block = jConditional1._then();
            JVar codeNodeJVar = jConditional1Block.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "codeNode", (IJExpression)assertJsonJVar.invoke("get").arg("code"));
            JConditional jConditional2 = jConditional1Block._if(codeNodeJVar.ne((IJExpression)JExpr._null()));
            JBlock jConditional2ThenBlock = jConditional2._then();
            JTryBlock jTry = jConditional2ThenBlock._try();
            jTry.body().assign((IJAssignmentTarget)responseBodyVar, (IJExpression)jInvocationTest);
            JCatchBlock jCatchBlock = jTry._catch(exceptionClass);
            JVar jExceptionVar = jCatchBlock.param("e");
            JBlock jCatchBlockBody = jCatchBlock.body();
            jCatchBlockBody.add((IJStatement)this.cmTest.ref("org.testng.Assert").staticInvoke("assertEquals").arg((IJExpression)jExceptionVar.invoke("getCode")).arg((IJExpression)codeNodeJVar.invoke("asText")).arg(JExpr.lit((String)"\u8fd4\u56de\u6d88\u606f\u7801\u4e0d\u662f\u6307\u5b9a\u6d88\u606f\u7801\uff1a").plus((IJExpression)codeNodeJVar.invoke("asText"))));
            jConditional2._else().assign((IJAssignmentTarget)responseBodyVar, (IJExpression)jInvocationTest);
            jConditional1._else().assign((IJAssignmentTarget)responseBodyVar, (IJExpression)jInvocationTest);
            methodTestBlk.add((IJStatement)JExpr.refthis((String)"log").invoke("debug").arg((IJExpression)JExpr.lit((String)"response={}")).arg((IJExpression)this.cmTest.ref("com.fastjrun.utils.JacksonUtils").staticInvoke("toJSon").arg((IJExpression)responseBodyVar)));
            JBlock ifBlock1 = methodTestBlk._if(responseBodyVar.ne((IJExpression)JExpr._null()))._then();
            if (this.getCommonMethod().isResponseIsArray()) {
                JForLoop forLoop = ifBlock1._for();
                JVar initIndexVar = forLoop.init((AbstractJType)this.cmTest.INT, "index", (IJExpression)JExpr.lit((int)0));
                forLoop.test(initIndexVar.lt((IJExpression)responseBodyVar.invoke("size")));
                forLoop.update(initIndexVar.incr());
                JBlock forBlock1 = forLoop.body();
                JVar responseBodyIndexVar = forBlock1.decl((AbstractJType)this.getElementClass(), "item" + this.getElementClass().name(), (IJExpression)responseBodyVar.invoke("get").arg((IJExpression)initIndexVar));
                MethodGeneratorHelper.logResponseBody(this.cmTest, this.log, this.packageNamePrefix, 1, this.getCommonMethod().getResponse(), responseBodyIndexVar, forBlock1);
            } else {
                MethodGeneratorHelper.logResponseBody(this.cmTest, this.log, this.packageNamePrefix, 1, this.getCommonMethod().getResponse(), responseBodyVar, ifBlock1);
            }
        } else {
            JConditional jConditional1 = methodTestBlk._if(assertJsonJVar.ne((IJExpression)JExpr._null()));
            JBlock jConditional1Block = jConditional1._then();
            JVar codeNodeJVar = jConditional1Block.decl((AbstractJType)this.cmTest.ref(JSONOBJECTCLASS_NAME), "codeNode", (IJExpression)assertJsonJVar.invoke("get").arg("code"));
            JConditional jConditional2 = jConditional1Block._if(codeNodeJVar.ne((IJExpression)JExpr._null()));
            JBlock jConditional2ThenBlock = jConditional2._then();
            JTryBlock jTry = jConditional2ThenBlock._try();
            jTry.body().add((IJStatement)jInvocationTest);
            JCatchBlock jCatchBlock = jTry._catch(exceptionClass);
            JVar jExceptionVar = jCatchBlock.param("e");
            JBlock jCatchBlockBody = jCatchBlock.body();
            jCatchBlockBody.add((IJStatement)this.cmTest.ref("org.testng.Assert").staticInvoke("assertEquals").arg((IJExpression)jExceptionVar.invoke("getCode")).arg((IJExpression)codeNodeJVar.invoke("asText")).arg(JExpr.lit((String)"\u8fd4\u56de\u6d88\u606f\u7801\u4e0d\u662f\u6307\u5b9a\u6d88\u606f\u7801\uff1a").plus((IJExpression)codeNodeJVar.invoke("asText"))));
            jConditional2._else().add((IJStatement)jInvocationTest);
            jConditional1._else().add((IJStatement)jInvocationTest);
        }
    }

    public void processServiceMockMethod() {
        this.jServiceMockMethod = this.serviceGenerator.getServiceMockClass().method(1, this.responseBodyClass, this.methodName);
        String methodRemark = this.commonMethod.getRemark();
        this.jServiceMockMethod.javadoc().append((Object)methodRemark);
        MethodGeneratorHelper.processServiceMethodVariables(this.jServiceMockMethod, this.commonMethod.getHeadVariables(), this.cm);
        MethodGeneratorHelper.processServiceMethodVariables(this.jServiceMockMethod, this.commonMethod.getPathVariables(), this.cm);
        MethodGeneratorHelper.processServiceMethodVariables(this.jServiceMockMethod, this.commonMethod.getParameters(), this.cm);
        MethodGeneratorHelper.processServiceMethodVariables(this.jServiceMockMethod, this.commonMethod.getCookieVariables(), this.cm);
        if (this.requestBodyClass != null) {
            this.jServiceMockMethod.param(this.requestBodyClass, "requestBody");
        }
        this.jServiceMockMethod.annotate(this.cm.ref("java.lang.Override"));
        JBlock serviceMockMethodBlock = this.jServiceMockMethod.body();
        if (this.responseBodyClass != this.cm.VOID) {
            if (!this.commonMethod.isResponseIsArray()) {
                if (this.responseBodyClass.name().endsWith("Boolean")) {
                    serviceMockMethodBlock._return((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geBoolean"));
                } else if (this.responseBodyClass.name().endsWith("Integer")) {
                    serviceMockMethodBlock._return((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geInteger"));
                } else if (this.responseBodyClass.name().endsWith("Long")) {
                    serviceMockMethodBlock._return((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geLong"));
                } else if (this.responseBodyClass.name().endsWith("Double")) {
                    serviceMockMethodBlock._return((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geDouble"));
                } else if (this.responseBodyClass.name().endsWith("String")) {
                    serviceMockMethodBlock._return((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geStringWithAlphabetic").arg((IJExpression)JExpr.lit((int)10)));
                } else if (this.responseBodyClass.name().endsWith("Date")) {
                    serviceMockMethodBlock._return((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geDate").arg((IJExpression)JExpr.lit((int)10)));
                } else {
                    JVar responseBodyVar = this.composeResponseBody(0, serviceMockMethodBlock, this.commonMethod.getResponse(), (AbstractJType)this.elementClass);
                    serviceMockMethodBlock._return((IJExpression)responseBodyVar);
                }
            } else if (this.elementClass.name().endsWith("Boolean")) {
                serviceMockMethodBlock._return((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geBooleanList").arg((IJExpression)JExpr.lit((int)10)));
            } else if (this.elementClass.name().endsWith("Integer")) {
                serviceMockMethodBlock._return((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geIntegerList").arg((IJExpression)JExpr.lit((int)10)));
            } else if (this.elementClass.name().endsWith("Long")) {
                serviceMockMethodBlock._return((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geLongList").arg((IJExpression)JExpr.lit((int)10)));
            } else if (this.elementClass.name().endsWith("Double")) {
                serviceMockMethodBlock._return((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geDoubleList").arg((IJExpression)JExpr.lit((int)10)));
            } else if (this.elementClass.name().endsWith("String")) {
                serviceMockMethodBlock._return((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geStringListWithAscii").arg((IJExpression)JExpr.lit((int)10)));
            } else if (this.elementClass.name().endsWith("Date")) {
                serviceMockMethodBlock._return((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geDateList").arg((IJExpression)JExpr.lit((int)10)));
            } else {
                JVar responseVar = serviceMockMethodBlock.decl(this.responseBodyClass, "response", (IJExpression)JExpr._new((AbstractJType)this.cm.ref("java.util.ArrayList").narrow(this.elementClass)));
                JVar responseBodyVar = this.composeResponseBody(0, serviceMockMethodBlock, this.commonMethod.getResponse(), (AbstractJType)this.elementClass);
                serviceMockMethodBlock.add((IJStatement)responseVar.invoke("add").arg((IJExpression)responseBodyVar));
                serviceMockMethodBlock._return((IJExpression)responseVar);
            }
        }
    }

    private JVar composeResponseBody(int loopSeq, JBlock methodBlk, PacketObject responseBody, AbstractJType responseBodyClass) {
        Map<String, PacketObject> roList;
        JVar responseVar = this.composeResponseBodyField(loopSeq, methodBlk, responseBody, responseBodyClass);
        int start = 1;
        Map<String, PacketObject> packetObjectMap = responseBody.getObjects();
        if (packetObjectMap != null && packetObjectMap.size() > 0) {
            for (String reName : packetObjectMap.keySet()) {
                String char2;
                PacketObject ro = packetObjectMap.get(reName);
                AbstractJClass roClass = this.cm.ref(this.packageNamePrefix + ro.get_class());
                if (!ro.is_new()) {
                    roClass = this.cm.ref(ro.get_class());
                }
                JVar roVar = this.composeResponseBody(loopSeq + start++, methodBlk, ro, (AbstractJType)roClass);
                String tterMethodName = reName;
                if (reName.length() > 1 && !(char2 = String.valueOf(reName.charAt(1))).equals(char2.toUpperCase())) {
                    tterMethodName = StringHelper.toUpperCaseFirstOne((String)reName);
                }
                methodBlk.add((IJStatement)responseVar.invoke("set" + tterMethodName).arg((IJExpression)roVar));
            }
        }
        if ((roList = responseBody.getLists()) != null && roList.size() > 0) {
            for (String listName : roList.keySet()) {
                String char2;
                int index = 0;
                PacketObject ro = roList.get(listName);
                AbstractJClass roListEntityClass = this.cm.ref(this.packageNamePrefix + ro.get_class());
                if (!ro.is_new()) {
                    roListEntityClass = this.cm.ref(ro.get_class());
                }
                String varNamePrefixList = StringHelper.toLowerCaseFirstOne((String)roListEntityClass.name().substring(roListEntityClass.name().lastIndexOf(".") + 1));
                JVar listsVar = methodBlk.decl((AbstractJType)this.cm.ref("java.util.List").narrow((AbstractJType)roListEntityClass), varNamePrefixList + "list", (IJExpression)JExpr._new((AbstractJType)this.cm.ref("java.util.ArrayList").narrow((AbstractJType)roListEntityClass)));
                JVar iSizeVar = methodBlk.decl((AbstractJType)this.cm.INT, "iSize" + listName + loopSeq + index, (IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geInteger").arg((IJExpression)JExpr.lit((int)10)).invoke("intValue"));
                JForLoop forLoop = methodBlk._for();
                JVar iVar = forLoop.init((AbstractJType)this.cm.INT, "i" + loopSeq + index, (IJExpression)JExpr.lit((int)0));
                forLoop.test(iVar.lt((IJExpression)iSizeVar));
                forLoop.update(iVar.incr());
                JBlock forBody = forLoop.body();
                JVar roVar = this.composeResponseBody(loopSeq + start++, forBody, ro, (AbstractJType)roListEntityClass);
                forBody.add((IJStatement)listsVar.invoke("add").arg((IJExpression)roVar));
                String tterMethodName = listName;
                if (listName.length() > 1 && !(char2 = String.valueOf(listName.charAt(1))).equals(char2.toUpperCase())) {
                    tterMethodName = StringHelper.toUpperCaseFirstOne((String)listName);
                }
                methodBlk.add((IJStatement)responseVar.invoke("set" + tterMethodName).arg((IJExpression)listsVar));
                ++index;
            }
        }
        return responseVar;
    }

    private JVar composeResponseBodyField(int loopSeq, JBlock methodBlk, PacketObject responseBody, AbstractJType responseBodyClass) {
        String varNamePrefix = StringHelper.toLowerCaseFirstOne((String)responseBody.get_class().substring(responseBody.get_class().lastIndexOf(".") + 1)) + loopSeq;
        JVar reponseBodyVar = methodBlk.decl(responseBodyClass, varNamePrefix, (IJExpression)JExpr._new((AbstractJType)responseBodyClass));
        Map<String, PacketField> restFields = responseBody.getFields();
        if (restFields != null && restFields.size() > 0) {
            for (String fieldName : restFields.keySet()) {
                String setter;
                String char2;
                AbstractJClass jType;
                PacketField restField = restFields.get(fieldName);
                String dataType = restField.getDatatype();
                String length = restField.getLength();
                String primitiveType = null;
                if (dataType.endsWith(":List")) {
                    primitiveType = dataType.split(":")[0];
                    jType = this.cm.ref("java.util.List").narrow(this.cm.ref(primitiveType));
                } else {
                    jType = this.cm.ref(dataType);
                }
                String tterMethodName = fieldName;
                if (fieldName.length() > 1 && !(char2 = String.valueOf(fieldName.charAt(1))).equals(char2.toUpperCase())) {
                    tterMethodName = StringHelper.toUpperCaseFirstOne((String)fieldName);
                }
                if ((setter = restField.getSetter()) == null || setter.equals("")) {
                    tterMethodName = "set" + tterMethodName;
                }
                if (primitiveType != null) {
                    if (primitiveType.endsWith("String")) {
                        methodBlk.add((IJStatement)reponseBodyVar.invoke(tterMethodName).arg((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geStringListWithAscii").arg((IJExpression)JExpr.lit((int)10))));
                        continue;
                    }
                    if (primitiveType.endsWith("Boolean")) {
                        methodBlk.add((IJStatement)reponseBodyVar.invoke(tterMethodName).arg((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geBooleanList").arg((IJExpression)JExpr.lit((int)10))));
                        continue;
                    }
                    if (primitiveType.endsWith("Integer")) {
                        methodBlk.add((IJStatement)reponseBodyVar.invoke(tterMethodName).arg((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geIntegerList").arg((IJExpression)JExpr.lit((int)10))));
                        continue;
                    }
                    if (primitiveType.endsWith("Long")) {
                        methodBlk.add((IJStatement)reponseBodyVar.invoke(tterMethodName).arg((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geLongList").arg((IJExpression)JExpr.lit((int)10))));
                        continue;
                    }
                    if (primitiveType.endsWith("Float")) {
                        methodBlk.add((IJStatement)reponseBodyVar.invoke(tterMethodName).arg((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geFloatList").arg((IJExpression)JExpr.lit((int)10))));
                        continue;
                    }
                    if (primitiveType.endsWith("Double")) {
                        methodBlk.add((IJStatement)reponseBodyVar.invoke(tterMethodName).arg((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geDoubleList").arg((IJExpression)JExpr.lit((int)10))));
                        continue;
                    }
                    if (primitiveType.endsWith("Date")) {
                        methodBlk.add((IJStatement)reponseBodyVar.invoke(tterMethodName).arg((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geDateList").arg((IJExpression)JExpr.lit((int)10))));
                        continue;
                    }
                    throw new CodeGException("CG504", responseBodyClass.name() + "." + tterMethodName + " handled failed:for" + dataType);
                }
                if (jType.name().endsWith("String")) {
                    methodBlk.add((IJStatement)reponseBodyVar.invoke(tterMethodName).arg((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geStringWithAscii").arg((IJExpression)JExpr.lit((int)Integer.parseInt(length)))));
                    continue;
                }
                if (jType.name().endsWith("Boolean")) {
                    methodBlk.add((IJStatement)reponseBodyVar.invoke(tterMethodName).arg((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geBoolean")));
                    continue;
                }
                if (jType.name().endsWith("Integer")) {
                    methodBlk.add((IJStatement)reponseBodyVar.invoke(tterMethodName).arg((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geInteger").arg((IJExpression)JExpr.lit((int)100))));
                    continue;
                }
                if (jType.name().endsWith("Long")) {
                    methodBlk.add((IJStatement)reponseBodyVar.invoke(tterMethodName).arg((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geLong").arg((IJExpression)JExpr.lit((int)100))));
                    continue;
                }
                if (jType.name().endsWith("Float")) {
                    methodBlk.add((IJStatement)reponseBodyVar.invoke(tterMethodName).arg((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geFloat").arg((IJExpression)JExpr.lit((int)100))));
                    continue;
                }
                if (jType.name().endsWith("Double")) {
                    methodBlk.add((IJStatement)reponseBodyVar.invoke(tterMethodName).arg((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geDouble").arg((IJExpression)JExpr.lit((int)100))));
                    continue;
                }
                if (jType.name().endsWith("Date")) {
                    methodBlk.add((IJStatement)reponseBodyVar.invoke(tterMethodName).arg((IJExpression)this.cm.ref(mockHelperClassName).staticInvoke("geDate").arg((IJExpression)JExpr.lit((int)100))));
                    continue;
                }
                throw new CodeGException("CG504", responseBodyClass.name() + "." + tterMethodName + " handled failed:for" + dataType);
            }
        }
        return reponseBodyVar;
    }

    @Override
    public void generate() {
        this.methodName = this.commonMethod.getName();
        String methodVersion = this.commonMethod.getVersion();
        if (methodVersion != null && !methodVersion.equals("")) {
            this.methodName = this.methodName + methodVersion;
        }
        this.doParse();
        if (!this.isApi()) {
            this.processServiceMethod();
            if (this.serviceGenerator.isSupportTest()) {
                this.processServiceTestMethod();
            }
            if (!this.isClient() && this.getMockModel() != CodeGConstants.MockModel.MockModel_Common) {
                this.processServiceMockMethod();
            }
        }
    }
}

