/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.codeg.helper;

import com.fastjrun.codeg.common.FJColumn;
import com.fastjrun.codeg.common.FJTable;
import com.fastjrun.codeg.helper.SqlHelper;
import java.util.List;
import java.util.Map;

public class MysqlSqlHelper
implements SqlHelper {
    FJTable fjTable;

    public MysqlSqlHelper(FJTable fjTable) {
        this.fjTable = fjTable;
    }

    @Override
    public String getInsert() {
        StringBuilder sqlInsert = new StringBuilder("insert into ");
        sqlInsert.append(this.fjTable.getName()).append("(");
        StringBuilder sqlParam = new StringBuilder();
        StringBuilder sqlValue = new StringBuilder();
        Map<String, FJColumn> columns = this.fjTable.getColumns();
        int i = 0;
        for (FJColumn fjColumn : columns.values()) {
            String name = fjColumn.getName();
            if (fjColumn.isIdentity()) continue;
            if (i > 0) {
                sqlParam.append(",");
                sqlValue.append(",");
            }
            sqlParam.append("`").append(name).append("`");
            sqlValue.append("#{").append(fjColumn.getFieldName()).append("}");
            ++i;
        }
        sqlInsert.append((CharSequence)sqlParam);
        sqlInsert.append(") values(");
        sqlInsert.append((CharSequence)sqlValue);
        sqlInsert.append(")");
        return sqlInsert.toString();
    }

    @Override
    public String getUpdateByPK() {
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(this.fjTable.getName()).append(" set ");
        Map<String, FJColumn> fields = this.fjTable.getColumns();
        List<String> keyFields = this.fjTable.getPrimaryKeyColumnNames();
        int i = 0;
        for (FJColumn fjColumn : fields.values()) {
            String name = fjColumn.getName();
            if (keyFields.contains(name)) continue;
            if (i > 0) {
                sql.append(",");
            }
            sql.append("`").append(name).append("` = #{").append(fjColumn.getFieldName()).append("}");
            ++i;
        }
        sql.append(" where ");
        i = 0;
        for (String keyName : keyFields) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append("`").append(keyName).append("` = #{").append(fields.get(keyName).getFieldName()).append("}");
            ++i;
        }
        return sql.toString();
    }

    @Override
    public String getSelectByPK() {
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        Map<String, FJColumn> fields = this.fjTable.getColumns();
        List<String> keyFields = this.fjTable.getPrimaryKeyColumnNames();
        int i = 0;
        for (FJColumn fjColumn : fields.values()) {
            String name = fjColumn.getName();
            if (i > 0) {
                sql.append(",");
            }
            sql.append("`").append(name).append("` ").append(fjColumn.getFieldName());
            ++i;
        }
        sql.append(" from ").append(this.fjTable.getName()).append(" where ");
        i = 0;
        for (String key : keyFields) {
            FJColumn fjColumn = fields.get(key);
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append("`").append(key).append("` = #{").append(fjColumn.getFieldName()).append("}");
            ++i;
        }
        return sql.toString();
    }

    @Override
    public String getSelectByCondition() {
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        Map<String, FJColumn> fields = this.fjTable.getColumns();
        int i = 0;
        for (FJColumn fjColumn : fields.values()) {
            String name = fjColumn.getName();
            if (i > 0) {
                sql.append(",");
            }
            sql.append("`").append(name).append("` ").append(fjColumn.getFieldName());
            ++i;
        }
        sql.append(" from ").append(this.fjTable.getName());
        sql.append(" where 1 = 1 ");
        return sql.toString();
    }

    @Override
    public String getDeleteByPK() {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from ").append(this.fjTable.getName()).append(" where ");
        List<String> keyFields = this.fjTable.getPrimaryKeyColumnNames();
        int i = 0;
        for (String key : keyFields) {
            FJColumn fjColumn = this.fjTable.getColumns().get(key);
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append("`").append(key).append("` = #{").append(fjColumn.getFieldName()).append("}");
            ++i;
        }
        return sql.toString();
    }

    @Override
    public String getTotalCount(int conditionAndlimit) {
        StringBuilder sql = new StringBuilder();
        sql.append("select count(*) from ").append(this.fjTable.getName());
        if (conditionAndlimit == 1) {
            sql.append(" where 1 = 1 ");
        }
        return sql.toString();
    }

    @Override
    public String getQueryForList(int conditionAndlimit) {
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        Map<String, FJColumn> fields = this.fjTable.getColumns();
        int i = 0;
        for (FJColumn fjColumn : fields.values()) {
            String name = fjColumn.getName();
            if (i > 0) {
                sql.append(",");
            }
            sql.append("`").append(name).append("` ").append(fjColumn.getFieldName());
            ++i;
        }
        sql.append(" from ").append(this.fjTable.getName());
        if (conditionAndlimit == 1) {
            sql.append(" where 1 = 1 ");
        }
        return sql.toString();
    }
}

