/*
 * Decompiled with CFR 0.152.
 */
package com.fastjrun.executor;

import com.fastjrun.executor.BaseExecutor;
import com.fastjrun.executor.ExecutorManagerable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;

public abstract class BaseDataExecutor<T>
extends BaseExecutor
implements ExecutorManagerable {
    protected int fetchLimit = 1000;
    protected int pageTotal = 1;

    public int getPageTotal() {
        return this.pageTotal;
    }

    public int getFetchLimit() {
        return this.fetchLimit;
    }

    public void setFetchLimit(int fetchLimit) {
        this.fetchLimit = fetchLimit;
    }

    public abstract List<T> fetchItems(int var1);

    public abstract int processItem(T var1);

    public Future<Integer> batchProcess(T item) {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            this.log.error(this.semaphore.availablePermits() + "", (Throwable)e);
        }
        Callable<Integer> callable = () -> {
            int res = 0;
            try {
                res = this.processItem(item);
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
            this.semaphore.release();
            return res;
        };
        Future<Integer> future = null;
        while (future == null) {
            try {
                future = this.executorService.submit(callable);
            }
            catch (RejectedExecutionException e) {
                this.log.warn(this.semaphore.availablePermits() + "", (Throwable)e);
            }
        }
        return future;
    }
}

