package com.feingto.cloud.cache;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * 缓存接口
 *
 * @author longfei
 */
public interface ICache {
    /**
     * 获取全部值
     */
    <T> Map<String, T> get();

    /**
     * 获取指定键的值
     *
     * @param key 键
     */
    <T> T get(String key);

    /**
     * 设置键值
     *
     * @param key   键
     * @param value 值
     */
    void put(String key, Object value);

    /**
     * 设置键值有效期
     *
     * @param key        键
     * @param value      值
     * @param expireTime 过期时间，单位毫秒
     */
    void put(String key, Object value, long expireTime);

    /**
     * 设置键值有效期
     *
     * @param key        键
     * @param value      值
     * @param expireTime 过期时间
     * @param timeUnit   过期时间单位
     */
    void put(String key, Object value, long expireTime, TimeUnit timeUnit);

    /**
     * 获取缓存所有键
     */
    Set<String> keys();

    /**
     * 是否存在
     *
     * @param key 键
     */
    boolean has(String key);

    /**
     * 移除
     *
     * @param key 键
     */
    void remove(String key);

    /**
     * 根据前缀移除
     *
     * @param prefix 键前缀
     */
    void removeByPrefix(String prefix);

    /**
     * 清空缓存
     */
    void clear();
}
