package com.feingto.cloud.cache;

import java.util.List;
import java.util.Map;

/**
 * 数据缓存集合扩展接口
 *
 * @author longfei
 */
public interface IDataCache extends ICache {
    /**
     * 根据指定键的集合值
     *
     * @param key 键
     */
    <T> List<T> getList(String key);

    /**
     * 根据指定键的Map值
     *
     * @param key 键
     */
    <T> Map<String, T> getMap(String key);

    /**
     * 同步缓存
     */
    boolean sync();

}
