package com.feingto.cloud.cache;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.data.redis.connection.RedisConnectionCommands;
import org.springframework.data.redis.core.*;

/**
 * Redis 缓存管理器
 *
 * @author longfei
 */
@Accessors(chain = true)
public class RedisManager {
    @Getter
    @Setter
    private RedisTemplate<String, Object> template;

    public ValueOperations<String, Object> getValueStore() {
        return template.opsForValue();
    }

    public HashOperations<String, String, Object> getHashStore() {
        return template.opsForHash();
    }

    public ListOperations<String, Object> getListStore() {
        return template.opsForList();
    }

    public SetOperations<String, Object> getSetStore() {
        return template.opsForSet();
    }

    public ZSetOperations<String, Object> getZSetStore() {
        return template.opsForZSet();
    }

    public ClusterOperations<String, Object> getClusterStore() {
        return template.opsForCluster();
    }

    public HyperLogLogOperations<String, Object> getHyperLogLogStore() {
        return template.opsForHyperLogLog();
    }

    public String getPing() {
        return (String) template.execute((RedisCallback<Object>) RedisConnectionCommands::ping);
    }
}
