package com.feingto.cloud.cache.provider;

import com.feingto.cloud.cache.IDataCache;

import java.util.List;
import java.util.Map;

/**
 * 缓存扩展接口默认实现
 *
 * @author longfei
 */
@SuppressWarnings("unchecked")
public class DefaultDataCacheProvider extends DefaultCacheProvider implements IDataCache {
    private boolean isLoaded = false;

    @Override
    public <T> List<T> getList(String key) {
        if (!isLoaded) {
            this.sync();
        }

        return (List<T>) data.get(key);
    }

    @Override
    public <T> Map<String, T> getMap(String key) {
        if (!this.isLoaded) {
            this.sync();
        }

        return (Map<String, T>) this.filterExpire(data.get(key), key);
    }

    @Override
    public synchronized boolean sync() {
        isLoaded = true;
        return true;
    }
}
