package com.feingto.cloud.cache.provider;

import com.feingto.cloud.cache.IDataCache;
import com.feingto.cloud.kit.reflection.ReflectionKit;
import org.springframework.data.redis.core.RedisTemplate;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * Redis 哈希缓存操作
 *
 * @author longfei
 */
@SuppressWarnings("unchecked")
public abstract class RedisHashProvider<T> implements IDataCache {
    private final RedisHashCache<T> redisHashCache;
    private final Class<T> clazz;
    private final String key;

    public RedisHashProvider(RedisTemplate template, String key) {
        this.redisHashCache = new RedisHashCache<>(template);
        this.clazz = ReflectionKit.getClassGenricType(getClass());
        this.key = key;
    }

    @Override
    public Map<String, T> get() {
        return redisHashCache.get(this.key);
    }

    @Override
    public T get(String field) {
        return redisHashCache.get(key, field, clazz);
    }

    @Override
    public List<T> getList(String field) {
        return redisHashCache.getList(key, field, clazz);
    }

    @Override
    public Map<String, T> getMap(String key) {
        return redisHashCache.getMap(this.key, key, clazz);
    }

    @Override
    public void put(String field, Object value) {
        redisHashCache.put(key, field, value);
    }

    @Override
    public void put(String key, Object value, long expireTime) {

    }

    @Override
    public void put(String key, Object value, long expireTime, TimeUnit timeUnit) {

    }

    @Override
    public Set<String> keys() {
        return redisHashCache.keys(key);
    }

    @Override
    public boolean has(String field) {
        return redisHashCache.has(key, field);
    }

    @Override
    public void remove(String field) {
        redisHashCache.remove(key, field);
    }

    @Override
    public void removeByPrefix(String prefix) {
        redisHashCache.removeByPrefix(key, prefix);
    }

    @Override
    public void clear() {
        redisHashCache.clear(key);
    }

    @Override
    public boolean sync() {
        return false;
    }
}
