package com.feingto.cloud.cache.support;

import com.feingto.cloud.cache.provider.RedisHashCache;
import com.feingto.cloud.cache.provider.RedisProvider;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

/**
 * 缓存提供配置自动注入
 *
 * @author longfei
 */
@Slf4j
@Configurable
public class CacheProviderAutoConfiguration {
    @LoadBalanced
    @Bean
    public RestTemplate restTemplate() {
        log.info("Bean '{}' has been injected", RestTemplate.class.getName());
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setConnectTimeout(3000);
        factory.setReadTimeout(8000);
        return new RestTemplate(factory);
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisProvider redisProvider(RedisTemplate redisTemplate) {
        log.info("Bean '{}' has been injected", RedisProvider.class.getName());
        return new RedisProvider(redisTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisHashCache redisHashCache(RedisTemplate redisTemplate) {
        log.info("Bean '{}' has been injected", RedisHashCache.class.getName());
        return new RedisHashCache(redisTemplate);
    }
}
