package com.feingto.cloud.data.jdbc;

import com.feingto.cloud.kit.json.JSON;
import com.google.common.collect.Maps;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 数据转换
 *
 * @author longfei
 */
public class DataTransform {
    public static String mergeSql(String sql, String[] field, String[] value) {
        Map<String, String> paramsMap = Maps.newHashMap();
        if (Objects.nonNull(field) && field.length > 0 && Objects.nonNull(value) && value.length > 0) {
            for (int i = 0; i < field.length; i++) {
                paramsMap.put(field[i], value[i]);
            }
        }
        return mergeSql(sql, paramsMap);
    }

    public static String mergeSql(String sql, Map<String, String> paramsMap) {
        String regex = "\\{#(\\S+)#\\}";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(sql);
        while (matcher.find()) {
            String name = matcher.group(1);
            if (StringUtils.hasText(paramsMap.get(name))) {
                sql = sql.replace("{#" + name + "#}", paramsMap.get(name));
            }
        }
        return sql;
    }

    public static String toJSON(List<Map<String, Object>> data) {
        return JSON.obj2json(data);
    }

    public static String toXML(List<Map<String, Object>> data) {
        if (data.size() == 0) return "";
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><list>");
        for (Map<String, Object> map : data) {
            xml.append("<data>");
            for (String key : map.keySet()) {
                xml.append("<prop key=\"").append(key).append("\"><![CDATA[").append(map.get(key)).append("]]></prop>");
            }
            xml.append("</data>");
        }
        xml.append("</list>");
        return xml.toString();
    }

    public static String toHTML(List<Map<String, Object>> data) {
        if (data.size() == 0) return "";
        StringBuilder html = new StringBuilder("<table class='table table-bordered table-condensed'>");
        StringBuilder head = new StringBuilder("<thead><tr>");
        StringBuilder body = new StringBuilder("<tbody><tr>");
        for (int i = 0; i < data.size(); i++) {
            Map<String, Object> map = data.get(i);
            for (String key : map.keySet()) {
                if (i == 0) {
                    head.append("<th>").append(key).append("</th>");
                }
                body.append("<td>").append(map.get(key)).append("</td>");
            }
            body.append("</tr><tr>");
        }
        head.append("</tr></thead>");
        body.append("</tr></tbody>");
        html.append(head).append(body).append("</table>");
        return html.toString();
    }
}
