package com.feingto.cloud.data.jdbc.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 数据记录
 *
 * @author longfei
 */
public class Record implements Serializable {
    private static final long serialVersionUID = -2573160621413846065L;

    private Map<String, Object> dataMap;

    public Record() {
        this.dataMap = new HashMap<>();
    }

    public Record(Map<String, Object> dataMap) {
        if (Objects.isNull(dataMap)) {
            this.dataMap = new HashMap<>();
        } else {
            this.dataMap = dataMap;
        }

    }

    public Record set(String column, Object value) {
        this.dataMap.put(column, value);
        return this;
    }

    public Object get(String column) {
        return this.dataMap.get(column);
    }

    public String getString(String column) {
        return (String) this.dataMap.get(column);
    }

    public Integer getInt(String column) {
        return (Integer) this.dataMap.get(column);
    }

    public BigInteger getBigInt(String column) {
        return (BigInteger) this.dataMap.get(column);
    }

    public Long getLong(String column) {
        return (Long) this.dataMap.get(column);
    }

    public BigDecimal getBigDecimal(String column) {
        return (BigDecimal) this.dataMap.get(column);
    }

    public Date getDate(String column) {
        return (Date) this.dataMap.get(column);
    }

    public Time getTime(String column) {
        return (Time) this.dataMap.get(column);
    }

    public Timestamp getTimestamp(String column) {
        return (Timestamp) this.dataMap.get(column);
    }

    public Double getDouble(String column) {
        return (Double) this.dataMap.get(column);
    }

    public Float getFloat(String column) {
        return (Float) this.dataMap.get(column);
    }

    public Boolean getBoolean(String column) {
        return (Boolean) this.dataMap.get(column);
    }

    public byte[] getBytes(String column) {
        return (byte[]) this.dataMap.get(column);
    }

    public Number getNumber(String column) {
        return (Number) this.dataMap.get(column);
    }

    public String[] getColumns() {
        return this.dataMap.keySet().toArray(new String[0]);
    }

    public Object[] getValues() {
        return this.dataMap.values().toArray(new Object[0]);
    }
}
