package com.feingto.cloud.data.jdbc.model;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 表结构
 *
 * @author longfei
 */
@Data
@Accessors(chain = true)
public class Table implements Serializable {
    private static final long serialVersionUID = -7707088903821827115L;

    private String catalog;

    private String schema;

    private String name;

    private String description;

    private String type;

    private List<Map<String, Object>> foreignKeys = new ArrayList<>();

    private List<Map<String, Object>> indices = new ArrayList<>();

    private List<TableColumn> columns = new ArrayList<>();
}
