package com.feingto.cloud.data.jdbc.table;

import com.feingto.cloud.data.jpa.BaseService;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.util.StringUtils;

import java.util.Map;

/**
 * 数据表操作
 *
 * @author longfei
 */
public class FormTableBuilder {
    private String tableName;
    private BaseService baseService;

    public FormTableBuilder(BaseService baseService, String tableName) {
        this.baseService = baseService;
        if (StringUtils.isEmpty(tableName)) {
            this.tableName = "wf_form_" + System.currentTimeMillis() + RandomStringUtils.randomNumeric(1);
        } else {
            this.tableName = tableName;
        }
    }

    /**
     * 删除表格
     *
     * @param type 数据库类型
     * @return boolean
     */
    public boolean dropTable(String type) {
        if ("oracle".equalsIgnoreCase(type)) {
            if (baseService.countBySql(FormTableSql.countTableSql("oracle", tableName, "orcl")) > 0) {
                baseService.executeBySql("drop table " + tableName);
            }
        } else if ("mysql".equalsIgnoreCase(type)) {
            baseService.executeBySql("drop table if exists " + tableName);
        }
        return true;
    }

    /**
     * 创建表格
     *
     * @param columnMapping Map<String, String>
     * @param type          数据库类型
     * @return boolean
     */
    public boolean createTable(Map<String, String> columnMapping, String type) {
        String separate = "oracle".equalsIgnoreCase(type) ? "" : "`";
        if (this.dropTable(type)) {
            if (!columnMapping.isEmpty()) {
                StringBuilder sql = new StringBuilder("create table " + tableName + " (" + separate + "id" + separate + " varchar(32),");
                for (String key : columnMapping.keySet()) {
                    String tag = columnMapping.get(key);
                    if (tag.equals("textarea"))
                        sql.append(separate).append(key).append(separate).append(" text,");
                    else
                        sql.append(separate).append(key).append(separate).append(" varchar(100),");
                }
                sql.append("PRIMARY KEY (").append(separate).append("id").append(separate).append("))");
                baseService.executeBySql(sql.toString());
            }
        }
        return true;
    }

    public String getTableName() {
        return tableName;
    }
}
