package com.feingto.cloud.data.jdbc.table;

import lombok.extern.slf4j.Slf4j;

/**
 * 数据库表操作sql
 *
 * @author longfei
 */
@Slf4j
public class FormTableSql {
    /**
     * 查询全部表结构
     *
     * @param type   数据库类型
     * @param schema 数据库名schema
     * @param where  where后面的条件语句字符串, 不包含where关键字
     * @return sql
     */
    public static String selectTablesSql(String type, String schema, String where) {
        String sql = "";
        if ("oracle".equalsIgnoreCase(type)) {
            sql = "select table_name, comments as table_comment from user_tab_comments where " + where;
        } else if ("mysql".equalsIgnoreCase(type)) {
            sql = "select table_name, table_comment from information_schema.tables where table_schema='" + schema + "' and " + where;
        }
        log.debug(sql);
        return sql;
    }

    /**
     * 查询单个表结构
     *
     * @param type      数据库类型
     * @param tableName 表名
     * @param schema    数据库名schema
     * @return sql
     */
    public static String selectTableSql(String type, String tableName, String schema) {
        String sql = "";
        if ("oracle".equalsIgnoreCase(type)) {
            sql = "select t1.table_name,t1.column_name,t2.comments as column_comment from user_tab_columns t1,user_col_comments t2  " +
                    "where t1.table_name = t2.table_name and t1.table_name in (" + tableName + ") group by t1.table_name,t1.column_name,t2.comments";
        } else if ("mysql".equalsIgnoreCase(type)) {
            sql = String.format("select table_schema,table_name,column_name,column_comment from information_schema.columns " +
                    "where table_schema='%s' and table_name in (%s) order by table_schema, table_name", schema, tableName);
        }
        log.debug(sql);
        return sql;
    }

    /**
     * 统计表数量
     *
     * @param type      数据库类型
     * @param tableName 表名
     * @param schema    数据库名schema
     * @return sql
     */
    public static String countTableSql(String type, String tableName, String schema) {
        String sql = "";
        if ("oracle".equalsIgnoreCase(type)) {
            sql = "select count(*) from user_tables where table_name=upper('" + tableName + "')";
        } else if ("mysql".equalsIgnoreCase(type)) {
            sql = "select count(*) from information_schema.tables where table_schema='" + schema + "' and table_name=upper('" + tableName + "')";
        }
        log.debug(sql);
        return sql;
    }

    /**
     * 查询表字段信息
     *
     * @param type      数据库类型
     * @param tableName 表名
     * @param schema    数据库名schema
     * @return sql
     */
    public static String selectColumnsSql(String type, String tableName, String schema) {
        String sql = "";
        if ("oracle".equalsIgnoreCase(type)) {
            sql = "select column_name,data_type,data_length,data_precision,data_scale from user_tab_columns where table_name=upper('" + tableName + "')";
        } else if ("mysql".equalsIgnoreCase(type)) {
            sql = "select column_name,data_type,character_maximum_length,numeric_precision,numeric_scale from information_schema.columns where table_schema='" + schema + "' and table_name=upper('" + tableName + "')";
        }
        log.debug(sql);
        return sql;
    }

    /**
     * 查询表外键
     *
     * @param type      数据库类型
     * @param tableName 表名
     * @return sql
     */
    public static String selectForgetKeySql(String type, String tableName) {
        String sql = "";
        if ("oracle".equalsIgnoreCase(type)) {
            sql = "select * from user_constraints c where c.constraint_type = 'R' and c.table_name=upper('" + tableName + "')";
        } else if ("mysql".equalsIgnoreCase(type)) {
            sql = "select table_name,column_name,constraint_name, referenced_table_name,referenced_column_name " +
                    "from information_schema.key_column_usage where table_name = '" + tableName + "'";
        }
        log.debug(sql);
        return sql;
    }

    /**
     * 获取最后插入ID
     *
     * @param type 数据库类型
     * @return sql
     */
    public static String lastInsert(String type) {
        String sql = "";
        if ("oracle".equalsIgnoreCase(type)) {
            sql = "select sys_guid() from dual";
        } else if ("mysql".equalsIgnoreCase(type)) {
            sql = "select last_insert_id()";
        }
        log.debug(sql);
        return sql;
    }
}
