package com.feingto.cloud.data.jpa;

import com.feingto.cloud.data.bean.OrderSort;
import com.feingto.cloud.data.bean.Page;
import com.feingto.cloud.data.jpa.provider.IBaseProvider;
import com.feingto.cloud.data.jpa.specification.bean.Condition;

import javax.persistence.criteria.JoinType;
import java.io.Serializable;
import java.util.List;

/**
 * 通用泛型服务接口扩展
 *
 * @author longfei
 */
public interface IBase<T, ID extends Serializable> extends IBaseProvider<T, ID> {
    /**
     * 根据ID修改多个condition的值（运算符规定是EQ，其他运算符忽略）
     *
     * @param id    ID
     * @param value Condition值
     */
    void updateByProperty(ID id, Condition value);

    /**
     * 根据多个condition条件修改多个condition值（运算符规定是EQ，其他运算符忽略）
     *
     * @param condition Condition条件
     * @param value     Condition值
     */
    void updateByProperty(Condition condition, Condition value);

    /**
     * 根据条件删除
     *
     * @param condition 查询参数封装
     */
    void delete(Condition condition);

    /**
     * 根据条件统计数量
     *
     * @param condition 查询参数封装
     * @return Long
     */
    Long count(Condition condition);

    /**
     * 根据条件查询单个
     *
     * @param condition 查询参数封装
     * @return entity
     */
    T findOne(Condition condition);

    /**
     * 条件查询
     *
     * @param condition 查询参数封装
     */
    List<T> findAll(Condition condition);

    /**
     * 条件查询并排序
     *
     * @param condition 查询参数封装
     * @param sort      Order by 对象
     */
    List<T> findAll(Condition condition, OrderSort sort);

    /**
     * 条件查询并排序
     *
     * @param condition 查询参数封装
     * @param sort      Order by 对象
     * @param joinType  JoinType
     */
    List<T> findAll(Condition condition, OrderSort sort, JoinType joinType);

    /**
     * 条件查询, 逐步加载
     *
     * @param condition 查询参数封装
     */
    List<T> findAllByPage(Condition condition);

    /**
     * 分页条件查询
     *
     * @param condition 查询参数封装
     * @param page      Page<T>
     */
    Page<T> findByPage(Condition condition, Page<T> page);

    /**
     * 分页条件查询
     *
     * @param condition 查询参数封装
     * @param page      Page<T>
     * @param joinType  JoinType
     */
    Page<T> findByPage(Condition condition, Page<T> page, JoinType joinType);
}
