package com.feingto.cloud.data.jpa.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Objects;

/**
 * ID 基类
 *
 * @author longfei
 */
@JsonIgnoreProperties({"hibernateLazyInitializer", "handler"})
@Data
@Accessors(chain = true)
@MappedSuperclass
public class IdEntity {
    @Id
    @GenericGenerator(name = "uuid", strategy = "uuid2")
    @GeneratedValue(generator = "uuid")
    @Column(length = 64, unique = true, nullable = false)
    protected String id;

    @JsonIgnore
    @Transient
    public boolean isNew() {
        return Objects.isNull(this.getId());
    }
}
