package com.feingto.cloud.data.jpa.generator.model;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 实体模型
 *
 * @author longfei
 */
@Data
@Accessors(chain = true)
public class Entity implements Serializable {
    private static final long serialVersionUID = -8781879364919431955L;

    /**
     * 实体所属包名
     */
    private String javaPackage;

    /**
     * 实体类名
     */
    private String className;

    /**
     * 父类包名
     */
    private String superPackage;

    /**
     * 父类名
     */
    private String superclass;

    /**
     * 属性集合
     */
    private List<Property> properties;

    /**
     * 目标实体所属包名
     */
    private String targetPackage;

    public String getTargetPackage() {
        return StringUtils.hasText(this.targetPackage) ? this.targetPackage : this.javaPackage;
    }
}
