package com.feingto.cloud.data.jpa.provider;

import com.feingto.cloud.data.bean.OrderSort;
import com.feingto.cloud.data.bean.Page;

import java.io.Serializable;
import java.util.List;

/**
 * 通用泛型服务接口
 *
 * @author longfei
 */
public interface IBaseProvider<T, ID extends Serializable> extends ISqlProvider<T> {
    /**
     * 新增/修改
     *
     * @param entity POJO
     * @return entity
     */
    T save(T entity);

    /**
     * 动态更新, 对象属性值为空时不更新
     *
     * @param id     ID
     * @param entity POJO
     * @return entity
     */
    T update(ID id, T entity);

    /**
     * 根据 ID 修改属性值
     *
     * @param id           ID
     * @param propertyName 属性名
     * @param value        属性值
     */
    void updateByProperty(ID id, String propertyName, Object value);

    /**
     * 根据 ID 删除
     *
     * @param id ID
     */
    void delete(ID id);

    /**
     * 根据 ID 集合批量删除
     */
    void delete(ID[] ids);

    /**
     * 统计全部数量
     *
     * @return Long
     */
    Long count();

    /**
     * 根据 ID 查询
     *
     * @param id ID
     * @return entity
     */
    T findById(ID id);

    /**
     * 查询全部
     */
    List<T> findAll();

    /**
     * 查询全部并排序
     *
     * @param sort Order by 对象
     */
    List<T> findAll(OrderSort sort);

    /**
     * 分页查询
     *
     * @param page Page<T>
     */
    Page<T> findByPage(Page<T> page);
}
