package com.feingto.cloud.data.jpa.provider;

import java.util.List;

/**
 * 底层sql、hql操作接口
 *
 * @author longfei
 */
public interface ISqlProvider<T> {
    /**
     * 加载延迟对象
     *
     * @param lazyInit ILazyInitializer<T>
     */
    void setLazyInitializer(ILazyInitializer<T> lazyInit);

    /**
     * 执行 hql
     *
     * @param hql    HQL语句
     * @param params 参数
     */
    void execute(String hql, Object... params);

    /**
     * hql 统计
     *
     * @param hql    HQL语句
     * @param params 参数
     * @return long
     */
    long count(String hql, Object... params);

    /**
     * hql 查询
     *
     * @param hql    HQL语句
     * @param params 参数
     * @return Object
     */
    Object getSingle(String hql, Object... params);

    /**
     * hql 查询
     *
     * @param hql    HQL语句
     * @param params 参数
     * @return List
     */
    List find(String hql, Object... params);

    /**
     * hql 查询
     *
     * @param hql    HQL语句
     * @param params 参数
     * @return T
     */
    T findOne(String hql, Object... params);

    /**
     * hql 查询
     *
     * @param hql    HQL语句
     * @param params 参数
     * @return List<T>
     */
    List<T> findAll(String hql, Object... params);

    /**
     * 执行 sql
     *
     * @param sql    SQL语句
     * @param params 参数
     */
    void executeBySql(String sql, Object... params);

    /**
     * sql 统计
     *
     * @param sql    SQL语句
     * @param params 参数
     * @return long
     */
    long countBySql(String sql, Object... params);

    /**
     * sql 查询
     *
     * @param sql    SQL语句
     * @param params 参数
     * @return Object
     */
    Object getSingleBySql(String sql, Object... params);

    /**
     * sql 查询
     *
     * @param sql    SQL语句
     * @param params 参数
     * @return List
     */
    List findBySql(String sql, Object... params);

    /**
     * sql 查询
     *
     * @param sql    SQL语句
     * @param params 参数
     * @return T
     */
    T findOneBySql(String sql, Object... params);

    /**
     * sql 查询
     *
     * @param sql    SQL语句
     * @param params 参数
     * @return List<T>
     */
    List<T> findAllBySql(String sql, Object... params);
}
