package com.feingto.cloud.data.jpa.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.PagingAndSortingRepository;

import java.io.Serializable;
import java.util.List;

/**
 * 通用JPA接口
 * extends JpaRepository<T, ID>, JpaSpecificationExecutor<T>, PagingAndSortingRepository<T, ID>
 *
 * @author longfei
 */
@NoRepositoryBean
public interface MyRepository<T, ID extends Serializable> extends JpaRepository<T, ID>, JpaSpecificationExecutor<T>, PagingAndSortingRepository<T, ID> {
    /**
     * 批量保存
     *
     * @param list List<T>
     */
    void batchInsert(List<T> list);

    /**
     * 批量更新
     *
     * @param list List<T>
     */
    void batchUpdate(List<T> list);

    /**
     * 自动生成有规则的标识, 例如 001
     *
     * @param fieldName 表字段名
     * @param length    001的长度
     * @return 有规则的标识字符串
     */
    String generateCode(String fieldName, int length);

    /**
     * 自动生成有规则的标识, 例如 user001
     *
     * @param fieldName 表字段名
     * @param length    001的长度
     * @param sign      user001中的user
     * @return 有规则的标识字符串
     */
    String generateCode(String fieldName, int length, String sign);
}
