package com.feingto.cloud.data.jpa.repository;

import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.util.StringUtils;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * 通用JPA接口实现
 *
 * @author longfei
 */
public class MyRepositoryImpl<T, ID extends Serializable> extends SimpleJpaRepository<T, ID> implements MyRepository<T, ID> {
    private final EntityManager em;

    public MyRepositoryImpl(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        // Keep the EntityManager around to used from the newly introduced methods.
        this.em = entityManager;
    }

    @Override
    public void batchInsert(List<T> list) {
        for (int i = 0; i < list.size(); i++) {
            em.persist(list.get(i));
            if (i % 50 == 0) {
                em.flush();
                em.clear();
            }
        }
    }

    @Override
    public void batchUpdate(List<T> list) {
        for (int i = 0; i < list.size(); i++) {
            em.merge(list.get(i));
            if (i % 50 == 0) {
                em.flush();
                em.clear();
            }
        }
    }

    @Override
    public String generateCode(String fieldName, int length) {
        return this.generateCode(fieldName, length, "");
    }

    @Override
    public String generateCode(String fieldName, int length, String sign) {
        String signStr = StringEscapeUtils.unescapeJava(sign);
        String tableName = super.getDomainClass().getAnnotation(Table.class).name();
        String sql = "select max(replace(a." + fieldName + ", '" + signStr + "', '') + 0) from " + tableName + " a where 1 = 1";
        if (StringUtils.isEmpty(sign)) {
            sql += " and a." + fieldName + " not regexp '[^0-9]'";
        } else {
            sql += " and a." + fieldName + " like '" + signStr + "%'";
        }
        Query query = em.createNativeQuery(sql);
        Object obj = query.getSingleResult();
        String max = Objects.nonNull(obj) ? obj.toString() : null;
        // 如果是第一次添加记录那么就是类似 user000000001
        if (StringUtils.isEmpty(max)) {
            max = "1";
            for (int i = 0; i < length - 1; i++) {
                max = "0" + max;
            }
            return signStr + max;
        } else {
            max = max.replaceFirst(sign, "");
            String returnNum = String.valueOf(Integer.parseInt(max) + 1);
            int zero;
            if (max.length() <= length + signStr.length()) {
                // 不是第一次添加记录, 记录的长度没有超过从配置文件中读取的长度
                zero = length - returnNum.length();
            } else {
                // 不是第一次的操作, 记录的长度超过了从配置文件中读取的长度
                zero = max.length() - returnNum.length();
            }
            for (int i = 0; i < zero; i++) {
                returnNum = "0" + returnNum;
            }
            return signStr + returnNum;
        }
    }
}
