package com.feingto.cloud.data.jpa.specification.bean;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 规则(字段、操作符、值)
 * <p>
 * JSON格式:
 * {"property":"id.sn","op":"EQ","value":"001"}
 *
 * @author longfei
 */
@Data
@Accessors(chain = true)
public class Rule implements Serializable {
    private static final long serialVersionUID = 4761866288675060103L;

    /**
     * 属性名
     */
    private String property;

    /**
     * 操作符
     */
    private Operator op;

    /**
     * 属性值
     */
    private Object value;

    /**
     * 标签
     */
    private String label;

    /**
     * 备注
     */
    private String remark;

    /**
     * 运算符
     */
    public enum Operator {
        /**
         * 等于
         */
        EQ,
        /**
         * 不等于
         */
        NEQ,
        /**
         * 以此开始
         */
        SLIKE,
        /**
         * 以此结束
         */
        ELIKE,
        /**
         * 包含
         */
        LIKE,
        /**
         * 大于
         */
        GT,
        /**
         * 小于
         */
        LT,
        /**
         * 大于或等于
         */
        GTE,
        /**
         * 小于或等于
         */
        LTE,
        /**
         * 包括
         */
        IN,
        /**
         * 不包括
         */
        NIN,
        /**
         * 空集合
         */
        ISEMPTY,
        /**
         * 非空集合
         */
        ISNOTEMPTY,
        /**
         * 空对象
         */
        ISNULL,
        /**
         * 非空对象
         */
        ISNOTNULL,
        /**
         * 是否真假
         */
        ISBOOLEAN,
        /**
         * true
         */
        ISTRUE,
        /**
         * false
         */
        ISFALSE;

        @JsonValue
        public String getName() {
            return name();
        }

        @JsonCreator
        public static Operator setName(String op) {
            for (Operator item : values()) {
                if (item.name().equalsIgnoreCase(op)) {
                    return item;
                }
            }
            return null;
        }
    }
}
