package com.feingto.cloud.data.jpa.specification.bean;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 规则组
 * <p>
 * JSON格式:
 * {"rules":[{"property":"id.sn","op":"EQ","value":"001"},{"property":"enabled","op":"EQ","value":"ENABLED"}],"op":"or"}
 *
 * @author longfei
 */
@Data
@Accessors(chain = true)
public class RuleGroup implements Serializable {
    private static final long serialVersionUID = -570028056922107807L;

    private List<Rule> rules = new ArrayList<>();

    /**
     * 操作符
     */
    private UnionOperator op;

    /**
     * 备注
     */
    private String remark;

    /**
     * 操作符(AND 或者 OR)
     */
    public enum UnionOperator {
        AND, OR;

        @JsonValue
        public String getName() {
            return name();
        }

        @JsonCreator
        public static UnionOperator setName(String op) {
            for (UnionOperator item : values()) {
                if (item.name().equalsIgnoreCase(op)) {
                    return item;
                }
            }
            return null;
        }
    }
}
