package com.feingto.cloud.data.jpa.utils;

import com.feingto.cloud.data.jpa.generator.model.Property;
import com.feingto.cloud.data.jpa.generator.model.PropertyType;
import com.feingto.cloud.kit.ClassKit;

import javax.persistence.Id;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Objects;

/**
 * Hibernate Jpa 工具
 *
 * @author longfei
 */
public class PersistenceUtils {
    /**
     * 得到实体的主键属性
     */
    public static Property getPkProperty(Class<?> clazz) {
        Property pkProperty = new Property();
        Field[] fields = ClassKit.getAllField(clazz);
        for (Field field : fields) {
            if (Objects.nonNull(field.getAnnotation(Id.class))) {
                pkProperty.setPropertyName(field.getName());
                pkProperty.setPropertyType(PropertyType.valueOf(field.getType().getSimpleName()));
                pkProperty.setPk(true);
                break;
            }
        }
        return pkProperty;
    }

    /**
     * 创建.java文件
     *
     * @param outDir        目标目录
     * @param javaPackage   java包名
     * @param javaClassName java类名
     * @return *.java File
     */
    public static File createJava(File outDir, String javaPackage, String javaClassName) {
        String packageSubPath = javaPackage.replace('.', '/');
        File packagePath = new File(outDir, packageSubPath);
        if (!packagePath.exists()) {
            packagePath.mkdirs();
        }
        return new File(packagePath, javaClassName + ".java");
    }
}
