/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.client;

import com.feingto.iot.client.bootstrap.MqttClientBootstrap;
import com.feingto.iot.client.config.NettyProperties;
import com.feingto.iot.client.service.MqttMessageService;
import com.feingto.iot.common.model.mqtt.SendMessage;
import com.feingto.iot.common.model.mqtt.SubscribeMessage;
import com.feingto.iot.common.service.ResponseCallback;
import com.feingto.iot.common.service.mqtt.MessageRequest;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttClient
extends MqttMessageService {
    private static final Logger log = LoggerFactory.getLogger(MqttClient.class);
    private final NettyProperties config;
    private final AtomicInteger retryLatch;
    private MqttClientBootstrap bootstrap;
    private Channel channel;
    private String[] topic;
    private int mqttQoS = 0;

    public MqttClient(NettyProperties config) {
        this.config = config;
        this.retryLatch = new AtomicInteger(config.getMqtt().getRetryMaxAttempts());
    }

    public MqttClient callback(ResponseCallback<SendMessage> callback) {
        this.setCallback(callback);
        return this;
    }

    public void connect() {
        this.bootstrap = new MqttClientBootstrap(this.config).addClient(this);
        this.channel = this.bootstrap.start();
        this.retryLatch.set(this.config.getMqtt().getRetryMaxAttempts());
        if (ArrayUtils.isNotEmpty((Object[])this.topic)) {
            this.subscribe(Arrays.stream(this.topic).map(topic -> new SubscribeMessage().mqttQoS(this.mqttQoS).topicName(topic)).collect(Collectors.toList()).toArray(new SubscribeMessage[this.topic.length]));
        }
    }

    public void reconnect() {
        this.destroy();
        if (this.retryLatch.getAndDecrement() > 0) {
            log.warn("Trying to reconnect");
            this.connect();
        }
    }

    public void publish(String topic, String message) {
        this.publish(topic, message, false, 0);
    }

    public void publish(String topic, String message, int qos) {
        this.publish(topic, message, false, qos);
    }

    public void publish(String topic, String message, boolean retained) {
        this.publish(topic, message, retained, 0);
    }

    public void publish(String topic, String message, boolean retained, int qos) {
        MessageRequest.publish((Channel)this.channel, (String)topic, (String)message, (boolean)retained, (int)qos);
    }

    public void subscribe(SubscribeMessage ... messages) {
        MessageRequest.subscribe((Channel)this.channel, Stream.of(messages).map(message -> new MqttTopicSubscription(message.topicName(), MqttQoS.valueOf((int)message.mqttQoS()))).collect(Collectors.toList()), (int)MessageRequest.idGenerator.nextId());
    }

    public void unsubscribe(String ... topics) {
        MessageRequest.unsubscribe((Channel)this.channel, Arrays.asList(topics), (int)MessageRequest.idGenerator.nextId());
    }

    public void destroy() {
        if (this.bootstrap != null) {
            this.bootstrap.close();
        }
    }

    public MqttClient topic(String[] topic) {
        this.topic = topic;
        return this;
    }

    public MqttClient mqttQoS(int mqttQoS) {
        this.mqttQoS = mqttQoS;
        return this;
    }
}

