/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.client.bootstrap;

import com.feingto.iot.client.MqttClient;
import com.feingto.iot.client.config.NettyProperties;
import com.feingto.iot.client.handler.MqttConnectListener;
import com.feingto.iot.common.model.custom.LoginMessage;
import com.feingto.iot.common.model.enums.TermType;
import com.feingto.iot.common.model.mqtt.MqttConnectOptions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBootstrap {
    private static final Logger log = LoggerFactory.getLogger(BaseBootstrap.class);
    protected final NettyProperties config;
    protected EventLoopGroup group;
    protected MqttClient mqttClient;
    private boolean initMessage = false;

    public BaseBootstrap(NettyProperties config) {
        this.config = config;
    }

    private void sendMessage(Channel channel) {
        int id = new Random().nextInt(100);
        channel.writeAndFlush((Object)new LoginMessage().id(Integer.toString(id)).token("token-" + id).username("guest-" + id).password(DigestUtils.md5Hex((String)"123456")).type(TermType.IOS.getValue()));
    }

    public abstract Bootstrap init();

    public Channel start() {
        MqttConnectOptions options = this.config.getMqtt();
        try {
            ChannelFuture future = this.init().connect(options.getHost(), options.getPort()).addListener((GenericFutureListener)new MqttConnectListener(options, this.mqttClient)).sync();
            if (this.initMessage && future.channel().isActive()) {
                this.sendMessage(future.channel());
            }
            log.info("IoT client listening on port [{}]", (Object)options.getPort());
            return future.channel();
        }
        catch (InterruptedException e) {
            log.error("IoT client exception: {}", (Object)e.getMessage());
            throw new RuntimeException(e.getCause());
        }
    }

    public void close() {
        log.info("IoT client shutdown");
        this.group.shutdownGracefully();
    }

    public void setInitMessage(boolean initMessage) {
        this.initMessage = initMessage;
    }
}

