/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.client.handler;

import com.feingto.iot.client.MqttClient;
import com.feingto.iot.common.handler.DefaultSimpleChannelHandler;
import com.feingto.iot.common.model.mqtt.MqttConnectOptions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@ChannelHandler.Sharable
public class MqttClientChannelHandler
extends DefaultSimpleChannelHandler<MqttMessage> {
    private final MqttConnectOptions options;
    private final MqttClient mqttClient;

    public MqttClientChannelHandler(MqttConnectOptions options, MqttClient mqttClient) {
        this.options = options;
        this.mqttClient = mqttClient;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.mqttClient.connect(ctx.channel(), this.options);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().eventLoop().schedule(this.mqttClient::reconnect, (long)this.options.getRetryInterval(), TimeUnit.SECONDS);
        super.channelInactive(ctx);
    }

    public void handleMessage(ChannelHandlerContext ctx, MqttMessage msg) {
        Optional.ofNullable(msg.fixedHeader()).ifPresent(fixedHeader -> {
            switch (fixedHeader.messageType()) {
                case CONNACK: {
                    this.mqttClient.connack((MqttConnAckMessage)msg);
                    break;
                }
                case PUBLISH: {
                    this.mqttClient.publish(ctx.channel(), msg);
                    break;
                }
                case PUBACK: {
                    this.mqttClient.puback(ctx.channel(), msg);
                    break;
                }
                case PUBREC: {
                    this.mqttClient.pubrec(ctx.channel(), msg);
                    break;
                }
                case PUBREL: {
                    this.mqttClient.pubrel(ctx.channel(), msg);
                    break;
                }
                case PUBCOMP: {
                    this.mqttClient.pubcomp(ctx.channel(), msg);
                    break;
                }
                case SUBACK: {
                    this.mqttClient.suback(ctx.channel(), (MqttSubAckMessage)msg);
                    break;
                }
                case UNSUBACK: {
                    this.mqttClient.unsubBack(ctx.channel(), msg);
                    break;
                }
            }
        });
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent event = (IdleStateEvent)evt;
            if (event.state() == IdleState.WRITER_IDLE) {
                this.mqttClient.pingreq(ctx.channel());
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.channel().eventLoop().schedule(this.mqttClient::reconnect, (long)this.options.getRetryInterval(), TimeUnit.SECONDS);
        this.mqttClient.exceptionCaught(cause);
    }
}

