/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.client;

import com.feingto.iot.client.bootstrap.MqttClientBootstrap;
import com.feingto.iot.client.config.NettyProperties;
import com.feingto.iot.client.service.MqttMessageService;
import com.feingto.iot.common.model.mqtt.SendMessage;
import com.feingto.iot.common.model.mqtt.SubscribeMessage;
import com.feingto.iot.common.service.ResponseCallback;
import com.feingto.iot.common.service.mqtt.MessageRequest;
import com.feingto.iot.common.util.MessageId;
import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttClient
extends MqttMessageService {
    private static final Logger log = LoggerFactory.getLogger(MqttClient.class);
    private final NettyProperties config;
    private final AtomicInteger latch = new AtomicInteger(10);
    private MqttClientBootstrap bootstrap;
    private Channel channel;

    public MqttClient callback(ResponseCallback<SendMessage> callback) {
        super.setCallback(callback);
        return this;
    }

    public MqttClient(NettyProperties config) {
        this.config = config;
    }

    public void connect() {
        this.bootstrap = new MqttClientBootstrap(this.config).mqttClient(this);
        try {
            this.channel = this.bootstrap.start();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            this.reconnect();
        }
    }

    public void reconnect() {
        this.destroy();
        log.info("Trying to reconnect");
        try {
            Thread.sleep(this.config.getMqtt().getTimeout() * 1000);
            if (this.latch.getAndDecrement() > 0) {
                this.connect();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void publish(String topic, String message) {
        this.publish(topic, message, false, 0);
    }

    public void publish(String topic, String message, int qos) {
        this.publish(topic, message, false, qos);
    }

    public void publish(String topic, String message, boolean retained) {
        this.publish(topic, message, retained, 0);
    }

    public void publish(String topic, String message, boolean retained, int qos) {
        MessageRequest.publish((Channel)this.channel, (SendMessage)new SendMessage().id(Integer.valueOf(MessageId.messageId())).topic(topic).mqttQoS(MqttQoS.valueOf((int)qos)).retain(retained).payload(message.getBytes()));
    }

    public void subscribe(SubscribeMessage ... messages) {
        MessageRequest.subscribe((Channel)this.channel, Stream.of(messages).map(message -> new MqttTopicSubscription(message.topicName(), MqttQoS.valueOf((int)message.mqttQoS()))).collect(Collectors.toList()), (int)MessageId.messageId());
    }

    public void unsubscribe(String ... topics) {
        MessageRequest.unsubscribe((Channel)this.channel, Arrays.asList(topics), (int)MessageId.messageId());
    }

    public void destroy() {
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.bootstrap != null) {
            this.bootstrap.close();
        }
    }
}

