/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.client.bootstrap;

import com.feingto.iot.common.model.custom.LoginMessage;
import com.feingto.iot.common.model.enums.TermType;
import com.feingto.iot.common.model.mqtt.MqttConnectOptions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBootstrap {
    private static final Logger log = LoggerFactory.getLogger(BaseBootstrap.class);
    protected final MqttConnectOptions options;
    protected EventLoopGroup group;
    private boolean startMessage = false;

    public BaseBootstrap(MqttConnectOptions options) {
        this.options = options;
    }

    private void sendMessage(Channel channel) {
        int id = new Random().nextInt(100);
        channel.writeAndFlush((Object)new LoginMessage().id(Integer.toString(id)).token("token-" + id).username("guest-" + id).password(DigestUtils.md5Hex((String)"123456")).type(TermType.IOS.getValue()));
    }

    public abstract Bootstrap init() throws InterruptedException;

    public Channel start() throws InterruptedException {
        ChannelFuture future = this.init().connect(this.options.getHost(), this.options.getPort()).sync();
        if (this.startMessage && future.channel().isActive()) {
            this.sendMessage(future.channel());
        }
        if (future.isDone()) {
            log.info("IoT client listening on port [{}]", (Object)this.options.getPort());
        }
        return future.channel();
    }

    public void close() {
        log.info("IoT client shutdown");
        this.group.shutdownGracefully();
    }

    public void setStartMessage(boolean startMessage) {
        this.startMessage = startMessage;
    }
}

