/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.client.bootstrap;

import com.feingto.iot.client.bootstrap.BaseBootstrap;
import com.feingto.iot.client.config.NettyProperties;
import com.feingto.iot.client.handler.CustomClientChannelHandler;
import com.feingto.iot.common.bootstrap.SimpleHandlerLoader;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class CustomClientBootstrap
extends BaseBootstrap {
    private final NettyProperties config;

    public CustomClientBootstrap(NettyProperties config) {
        super(config.getMqtt());
        this.config = config;
    }

    @Override
    public Bootstrap init() {
        this.group = new NioEventLoopGroup(this.config.getWorkThread(), (ThreadFactory)new DefaultThreadFactory("CLIENT_"));
        return (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.options.getTimeout())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                if (CustomClientBootstrap.this.options.getKeepAliveInterval() > 0) {
                    ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0L, (long)CustomClientBootstrap.this.options.getKeepAliveInterval(), 0L, TimeUnit.SECONDS)});
                }
                List handlers = SimpleHandlerLoader.getTcpHandlers();
                handlers.add(new IdleStateHandler(0L, 1L, 0L, TimeUnit.MINUTES));
                handlers.add(new CustomClientChannelHandler());
                handlers.forEach(handler -> ch.pipeline().addLast(new ChannelHandler[]{handler}));
            }
        });
    }
}

