/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.client.bootstrap;

import com.feingto.iot.client.MqttClient;
import com.feingto.iot.client.bootstrap.BaseBootstrap;
import com.feingto.iot.client.config.NettyProperties;
import com.feingto.iot.client.handler.MqttClientChannelHandler;
import com.feingto.iot.common.bootstrap.SimpleHandlerLoader;
import com.feingto.iot.common.model.mqtt.MqttConnectOptions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class MqttClientBootstrap
extends BaseBootstrap {
    private final NettyProperties config;
    private MqttClient mqttClient;

    public MqttClientBootstrap(NettyProperties config) {
        super(config.getMqtt());
        this.config = config;
    }

    @Override
    public Bootstrap init() {
        this.group = new NioEventLoopGroup(this.config.getWorkThread(), (ThreadFactory)new DefaultThreadFactory("CLIENT_"));
        final MqttConnectOptions options = this.config.getMqtt();
        return (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)options.getTimeout())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                if (options.getKeepAliveInterval() > 0) {
                    ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0L, (long)options.getKeepAliveInterval(), 0L, TimeUnit.SECONDS)});
                }
                SimpleHandlerLoader.getMqttChannelHandlers().forEach(arg_0 -> 1.lambda$initChannel$0(ch.pipeline(), arg_0));
                if (MqttClientBootstrap.this.mqttClient != null) {
                    ch.pipeline().addLast(new ChannelHandler[]{new MqttClientChannelHandler(options, MqttClientBootstrap.this.mqttClient)});
                }
            }

            private static /* synthetic */ void lambda$initChannel$0(ChannelPipeline rec$, ChannelHandler xva$0) {
                rec$.addLast(new ChannelHandler[]{xva$0});
            }
        });
    }

    public MqttClientBootstrap mqttClient(MqttClient mqttClient) {
        this.mqttClient = mqttClient;
        return this;
    }
}

