/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.client.config;

import com.feingto.iot.client.MqttClient;
import com.feingto.iot.client.config.NettyProperties;
import com.feingto.iot.client.config.annotation.MqttListener;
import com.feingto.iot.common.model.mqtt.SendMessage;
import com.feingto.iot.common.model.mqtt.SubscribeMessage;
import com.feingto.iot.common.service.ResponseCallback;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(annotation={MqttListener.class})
@EnableConfigurationProperties(value={NettyProperties.class})
public class MqttClientAutoConfiguration
implements ApplicationContextAware,
DisposableBean {
    private ConfigurableApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    @Bean
    @ConditionalOnMissingBean
    public MqttClient mqttClient() {
        MqttClient client = new MqttClient((NettyProperties)this.applicationContext.getBean(NettyProperties.class));
        Map beanMap = this.applicationContext.getBeansWithAnnotation(MqttListener.class);
        Optional.of(beanMap).ifPresent(map -> beanMap.forEach((name, bean) -> {
            Class clazz = AopUtils.getTargetClass((Object)bean);
            if (!ResponseCallback.class.isAssignableFrom(bean.getClass())) {
                throw new IllegalStateException(clazz + " is not instance of " + ResponseCallback.class.getName());
            }
            MqttListener annotation = clazz.getAnnotation(MqttListener.class);
            Object[] topics = annotation.topic();
            client.callback((ResponseCallback<SendMessage>)((ResponseCallback)bean)).connect();
            if (ArrayUtils.isNotEmpty((Object[])topics)) {
                client.subscribe(Arrays.stream(topics).map(topic -> new SubscribeMessage().mqttQoS(annotation.qos().value()).topicName(topic)).collect(Collectors.toList()).toArray(new SubscribeMessage[topics.length]));
            }
        }));
        return client;
    }

    public void destroy() {
        ((MqttClient)this.applicationContext.getBean(MqttClient.class)).destroy();
    }
}

