/*
 * Decompiled with CFR 0.152.
 */
package com.feingto.iot.client.handler;

import com.feingto.iot.common.handler.DefaultSimpleChannelHandler;
import com.feingto.iot.common.model.custom.BaseMessage;
import com.feingto.iot.common.model.custom.HeartMessage;
import com.feingto.iot.common.model.custom.Message;
import com.feingto.iot.common.model.custom.SystemMessage;
import com.feingto.iot.common.model.enums.MessageType;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomClientChannelHandler
extends DefaultSimpleChannelHandler<BaseMessage> {
    private static final Logger log = LoggerFactory.getLogger(CustomClientChannelHandler.class);

    public void handleMessage(ChannelHandlerContext ctx, BaseMessage msg) {
        byte protocol = msg.protocol();
        if (protocol == MessageType.LOGIN_RESPONSE.getValue()) {
            log.debug(">>> login success");
        } else if (protocol == MessageType.SYSTEM.getValue()) {
            log.debug(">>> subscription: {}", (Object)((SystemMessage)msg).content());
        } else if (protocol == MessageType.MESSAGE_RESPONSE.getValue()) {
            log.debug(">>> message: {}", (Object)((Message)msg).content());
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        IdleStateEvent event;
        if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state() == IdleState.WRITER_IDLE) {
            log.debug(">>> writer idle - [{}]", (Object)new Date());
            ctx.writeAndFlush((Object)new HeartMessage());
        }
    }
}

